/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class FunctionValue
extends TypedValue
implements CSSFunctionValue {
    private static final long serialVersionUID = 1L;
    private String functionName = null;
    private final LinkedCSSValueList arguments = new LinkedCSSValueList();

    public FunctionValue() {
        super(CSSValue.Type.FUNCTION);
    }

    protected FunctionValue(CSSValue.Type type) {
        super(type);
    }

    protected FunctionValue(FunctionValue copied) {
        super(copied);
        this.functionName = copied.functionName;
        this.arguments.addAll(copied.arguments);
    }

    public LinkedCSSValueList getArguments() {
        return this.arguments;
    }

    @Override
    public StyleValue getComponent(int index) {
        try {
            return (StyleValue)this.arguments.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        try {
            this.arguments.set(index, component);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public int getComponentCount() {
        return this.arguments.getLength();
    }

    void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case image: {
                return this.getPrimitiveType() == CSSValue.Type.SRC || CSSUtil.isUnimplementedImageFunction(this.functionName.toLowerCase(Locale.ROOT)) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case url: {
                return this.getPrimitiveType() == CSSValue.Type.SRC ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new FunctionLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(this.functionName.length() + this.arguments.size() * 8 + 12);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String pname) {
        StringBuilder buf = new StringBuilder(this.functionName.length() + this.arguments.size() * 8 + 12);
        buf.append(this.functionName).append('(');
        int sz = this.arguments.size();
        if (sz > 0) {
            buf.append(((StyleValue)this.arguments.get(0)).getMinifiedCssText(pname));
            for (int i = 1; i < sz; ++i) {
                buf.append(',').append(((StyleValue)this.arguments.get(i)).getMinifiedCssText(pname));
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.functionName);
        wri.write('(');
        int sz = this.arguments.size();
        if (sz == 1) {
            StyleValue first = (StyleValue)this.arguments.get(0);
            if (first.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)((Object)first)).getStringValue().length() == 0) {
                ((CSSExpressionValue)((Object)first)).getExpression().writeCssText(wri);
            } else {
                first.writeCssText(wri);
            }
        } else if (sz != 0) {
            ((StyleValue)this.arguments.get(0)).writeCssText(wri);
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                ((StyleValue)this.arguments.get(i)).writeCssText(wri);
            }
        }
        wri.write(')');
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.functionName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionValue other = (FunctionValue)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.functionName == null) {
            return other.functionName == null;
        }
        return this.functionName.equals(other.functionName);
    }

    @Override
    public FunctionValue clone() {
        return new FunctionValue(this);
    }

    class FunctionLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        FunctionLexicalSetter() {
            super(FunctionValue.this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            FunctionValue.this.functionName = lunit.getFunctionName();
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            boolean commaSep = false;
            ValueList list = null;
            while (true) {
                StyleValue newval;
                ValueItem item;
                block22: {
                    if (lu == null) {
                        this.nextLexicalUnit = lunit.getNextLexicalUnit();
                        return;
                    }
                    LexicalUnit.LexicalType type = lu.getLexicalUnitType();
                    if (type == LexicalUnit.LexicalType.SUB_EXPRESSION) {
                        item = this.subExpression(lu);
                        newval = item.getCSSValue();
                    } else {
                        if (type == LexicalUnit.LexicalType.LEFT_BRACKET) {
                            LexicalUnit nlu = lu.getNextLexicalUnit();
                            item = factory.parseBracketList(nlu, null, false);
                            if (item != null) {
                                newval = item.getCSSValue();
                                break block22;
                            } else {
                                lu = nlu.getNextLexicalUnit();
                                continue;
                            }
                        }
                        if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            if (list != null && list.getLength() == 1 && this.isOperand(list.item(0))) {
                                list = null;
                                item = this.expressionItem(lu);
                                newval = item.getCSSValue();
                            } else {
                                ValueFactory.BasicValueItem vbi = new ValueFactory.BasicValueItem();
                                vbi.nextLexicalUnit = lu.getNextLexicalUnit();
                                item = vbi;
                                newval = new UnknownValue();
                                ((UnknownValue)newval).setPlainCssText("/");
                            }
                        } else if (list != null && (type == LexicalUnit.LexicalType.OPERATOR_PLUS || type == LexicalUnit.LexicalType.OPERATOR_MINUS || type == LexicalUnit.LexicalType.OPERATOR_MULTIPLY) && list.getLength() == 1 && this.isOperand(list.item(0))) {
                            list = null;
                            item = this.expressionItem(lu);
                            newval = item.getCSSValue();
                        } else {
                            item = factory.createCSSPrimitiveValueItem(lu, false, true);
                            newval = item.getCSSValue();
                        }
                    }
                }
                lu = item.getNextLexicalUnit();
                if (lu != null) {
                    if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        lu = lu.getNextLexicalUnit();
                        if (!commaSep && !FunctionValue.this.arguments.isEmpty()) {
                            list = ValueList.createWSValueList();
                            Iterator it = FunctionValue.this.arguments.iterator();
                            while (it.hasNext()) {
                                list.add((StyleValue)it.next());
                            }
                            list.add(newval);
                            FunctionValue.this.arguments.clear();
                            FunctionValue.this.arguments.add(list);
                            list = null;
                        } else if (list == null) {
                            FunctionValue.this.arguments.add(newval);
                        } else {
                            list.add(newval);
                            list = null;
                        }
                        commaSep = true;
                        continue;
                    }
                    if (list == null) {
                        list = ValueList.createWSValueList();
                        list.add(newval);
                        FunctionValue.this.arguments.add(list);
                        continue;
                    }
                    list.add(newval);
                    continue;
                }
                if (list == null) {
                    FunctionValue.this.arguments.add(newval);
                    continue;
                }
                list.add(newval);
            }
        }

        private boolean isOperand(StyleValue value) {
            if (value.getCssValueType() == CSSValue.CssType.TYPED) {
                CSSTypedValue typed = (CSSTypedValue)((Object)value);
                CSSValue.Type pType = typed.getPrimitiveType();
                switch (pType) {
                    case NUMERIC: 
                    case EXPRESSION: 
                    case MATH_FUNCTION: {
                        return true;
                    }
                    case IDENT: {
                        return this.isConstant(typed.getStringValue());
                    }
                }
            }
            return false;
        }

        private boolean isConstant(String constname) {
            return "e".equalsIgnoreCase(constname) || "pi".equalsIgnoreCase(constname);
        }

        private ValueItem subExpression(LexicalUnit lu) {
            ExpressionValue expr = new ExpressionValue();
            ExpressionValue.ExpressionLexicalSetter setter = expr.newLexicalSetter();
            setter.setLexicalUnitFromSubValues(lu.getSubValues());
            LexicalUnit nextlex = lu.getNextLexicalUnit();
            if (nextlex != null) {
                LexicalUnit.LexicalType type = nextlex.getLexicalUnitType();
                if (type == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    setter.setLexicalUnitFromSubValues(lu);
                } else {
                    setter.setLexicalUnitFromSubValues(lu.getSubValues());
                    setter.nextLexicalUnit = nextlex;
                }
            }
            return setter;
        }

        private ValueItem expressionItem(LexicalUnit lu) {
            FunctionValue.this.arguments.removeLast();
            LexicalUnit firstOpLu = lu.getPreviousLexicalUnit();
            LexicalUnit delimLu = firstOpLu.getPreviousLexicalUnit();
            if (delimLu == null || delimLu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                ExpressionValue expr = new ExpressionValue();
                ExpressionValue.ExpressionLexicalSetter setter = expr.newLexicalSetter();
                setter.setLexicalUnitFromSubValues(firstOpLu);
                return setter;
            }
            throw new IllegalStateException();
        }
    }
}

