/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Directory
implements Serializable {
    protected final HashMap _tagMap = new HashMap();
    protected TagDescriptor _descriptor;
    protected final List _definedTagList = new ArrayList();
    private List _errorList;

    public abstract String getName();

    protected abstract HashMap getTagNameMap();

    public boolean containsTag(int tagType) {
        return this._tagMap.containsKey(new Integer(tagType));
    }

    public Iterator getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = descriptor;
    }

    public void addError(String message) {
        if (this._errorList == null) {
            this._errorList = new ArrayList();
        }
        this._errorList.add(message);
    }

    public boolean hasErrors() {
        return this._errorList != null && this._errorList.size() > 0;
    }

    public Iterator getErrors() {
        return this._errorList.iterator();
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setInt(int tagType, int value) {
        this.setObject(tagType, new Integer(value));
    }

    public void setDouble(int tagType, double value) {
        this.setObject(tagType, new Double(value));
    }

    public void setFloat(int tagType, float value) {
        this.setObject(tagType, new Float(value));
    }

    public void setString(int tagType, String value) {
        this.setObject(tagType, value);
    }

    public void setBoolean(int tagType, boolean value) {
        this.setObject(tagType, new Boolean(value));
    }

    public void setLong(int tagType, long value) {
        this.setObject(tagType, new Long(value));
    }

    public void setDate(int tagType, Date value) {
        this.setObject(tagType, value);
    }

    public void setRational(int tagType, Rational rational) {
        this.setObject(tagType, rational);
    }

    public void setRationalArray(int tagType, Rational[] rationals) {
        this.setObjectArray(tagType, rationals);
    }

    public void setIntArray(int tagType, int[] ints) {
        this.setObjectArray(tagType, ints);
    }

    public void setByteArray(int tagType, byte[] bytes) {
        this.setObjectArray(tagType, bytes);
    }

    public void setStringArray(int tagType, String[] strings) {
        this.setObjectArray(tagType, strings);
    }

    public void setObject(int tagType, Object value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null object");
        }
        Integer key = new Integer(tagType);
        if (!this._tagMap.containsKey(key)) {
            this._definedTagList.add(new Tag(tagType, this));
        }
        this._tagMap.put(key, value);
    }

    public void setObjectArray(int tagType, Object array) {
        this.setObject(tagType, array);
    }

    /*
     * Unable to fully structure code
     */
    public int getInt(int tagType) throws MetadataException {
        o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException nfe) {
                s = (String)o;
                bytes = s.getBytes();
                val = 0L;
                i = 0;
                ** while (i < bytes.length)
            }
lbl-1000:
            // 1 sources

            {
                val <<= 8;
                val += (long)bytes[i];
                ++i;
                continue;
            }
lbl17:
            // 1 sources

            return (int)val;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Rational[]) {
            rationals = (Rational[])o;
            if (rationals.length == 1) {
                return rationals[0].intValue();
            }
        } else if (o instanceof byte[]) {
            bytes = (byte[])o;
            if (bytes.length == 1) {
                return bytes[0];
            }
        } else if (o instanceof int[] && (ints = (int[])o).length == 1) {
            return ints[0];
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to int.  It is of type '" + o.getClass() + "'.");
    }

    public String[] getStringArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            String[] strings = new String[]{(String)o};
            return strings;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            String[] strings = new String[ints.length];
            int i = 0;
            while (i < strings.length) {
                strings[i] = Integer.toString(ints[i]);
                ++i;
            }
            return strings;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            String[] strings = new String[bytes.length];
            int i = 0;
            while (i < strings.length) {
                strings[i] = Byte.toString(bytes[i]);
                ++i;
            }
            return strings;
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            String[] strings = new String[rationals.length];
            int i = 0;
            while (i < strings.length) {
                strings[i] = rationals[i].toSimpleString(false);
                ++i;
            }
            return strings;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to an String array.  It is of type '" + o.getClass() + "'.");
    }

    public int[] getIntArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            int[] ints = new int[rationals.length];
            int i = 0;
            while (i < ints.length) {
                ints[i] = rationals[i].intValue();
                ++i;
            }
            return ints;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            int[] ints = new int[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                int b;
                ints[i] = b = bytes[i];
                ++i;
            }
            return ints;
        }
        if (o instanceof String) {
            String str = (String)o;
            int[] ints = new int[str.length()];
            int i = 0;
            while (i < str.length()) {
                ints[i] = str.charAt(i);
                ++i;
            }
            return ints;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to an int array.  It is of type '" + o.getClass() + "'.");
    }

    public byte[] getByteArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            Rational[] rationals = (Rational[])o;
            byte[] bytes = new byte[rationals.length];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = rationals[i].byteValue();
                ++i;
            }
            return bytes;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof int[]) {
            int[] ints = (int[])o;
            byte[] bytes = new byte[ints.length];
            int i = 0;
            while (i < ints.length) {
                bytes[i] = (byte)ints[i];
                ++i;
            }
            return bytes;
        }
        if (o instanceof String) {
            String str = (String)o;
            byte[] bytes = new byte[str.length()];
            int i = 0;
            while (i < str.length()) {
                bytes[i] = (byte)str.charAt(i);
                ++i;
            }
            return bytes;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a byte array.  It is of type '" + o.getClass() + "'.");
    }

    public double getDouble(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a double", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a double.  It is of type '" + o.getClass() + "'.");
    }

    public float getFloat(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a float", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a float.  It is of type '" + o.getClass() + "'.");
    }

    public long getLong(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a long", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a long.  It is of type '" + o.getClass() + "'.");
    }

    public boolean getBoolean(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.getBoolean((String)o);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o + " as a boolean", nfe);
            }
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a boolean.  It is of type '" + o.getClass() + "'.");
    }

    public Date getDate(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            String[] datePatterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String dateString = (String)o;
            int i = 0;
            while (i < datePatterns.length) {
                try {
                    SimpleDateFormat parser = new SimpleDateFormat(datePatterns[i]);
                    return parser.parse(dateString);
                }
                catch (ParseException parseException) {
                    ++i;
                }
            }
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a java.util.Date.  It is of type '" + o.getClass() + "'.");
    }

    public Rational getRational(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational) {
            return (Rational)o;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a Rational.  It is of type '" + o.getClass() + "'.");
    }

    public Rational[] getRationalArray(int tagType) throws MetadataException {
        Object o = this.getObject(tagType);
        if (o == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o instanceof Rational[]) {
            return (Rational[])o;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a Rational array.  It is of type '" + o.getClass() + "'.");
    }

    public String getString(int tagType) {
        Object o = this.getObject(tagType);
        if (o == null) {
            return null;
        }
        if (o instanceof Rational) {
            return ((Rational)o).toSimpleString(true);
        }
        if (o.getClass().isArray()) {
            int arrayLength = Array.getLength(o);
            boolean isObjectArray = o.getClass().toString().startsWith("class [L");
            StringBuffer sbuffer = new StringBuffer();
            int i = 0;
            while (i < arrayLength) {
                if (i != 0) {
                    sbuffer.append(' ');
                }
                if (isObjectArray) {
                    sbuffer.append(Array.get(o, i).toString());
                } else {
                    sbuffer.append(Array.getInt(o, i));
                }
                ++i;
            }
            return sbuffer.toString();
        }
        return o.toString();
    }

    public Object getObject(int tagType) {
        return this._tagMap.get(new Integer(tagType));
    }

    public String getTagName(int tagType) {
        Integer key = new Integer(tagType);
        HashMap nameMap = this.getTagNameMap();
        if (!nameMap.containsKey(key)) {
            String hex = Integer.toHexString(tagType);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            return "Unknown tag (0x" + hex + ")";
        }
        return (String)nameMap.get(key);
    }

    public String getDescription(int tagType) throws MetadataException {
        if (this._descriptor == null) {
            throw new MetadataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(tagType);
    }
}

