/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.rotate;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RotateLayout
extends AbstractLayout
implements Layout {
    private double angle;
    private Graph graph;

    public RotateLayout(LayoutBuilder layoutBuilder, double angle) {
        super(layoutBuilder);
        this.angle = angle;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            double sin = Math.sin(-this.getAngle().doubleValue() * Math.PI / 180.0);
            double cos = Math.cos(-this.getAngle().doubleValue() * Math.PI / 180.0);
            double px = 0.0;
            double py = 0.0;
            for (Node n : this.graph.getNodes()) {
                if (n.isFixed()) continue;
                double dx = (double)n.x() - px;
                double dy = (double)n.y() - py;
                n.setX((float)(px + dx * cos - dy * sin));
                n.setY((float)(py + dy * cos + dx * sin));
            }
            this.setConverged(true);
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
    }

    public void resetPropertiesValues() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"rotate.angle.name"), null, (String)"clockwise.angle.name", (String)NbBundle.getMessage(this.getClass(), (String)"rotate.angle.desc"), (String)"getAngle", (String)"setAngle"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }
}

