/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.JSUtils;
import org.jsampler.SamplerChannelModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;

public class StdA4n {
    protected static StdA4n a4n = new StdA4n();
    public final Action connect = new Connect();
    public final Action refresh = new Refresh();
    public final Action resetSampler = new Reset();
    public final Action exportSamplerConfig = new ExportSamplerConfig();
    public final Action exportMidiInstrumentMaps = new ExportMidiInstrumentMaps();
    public final Action changeBackend = new ChangeBackend();
    public final Action moveChannelsOnTop = new MoveChannelsOnTop();
    public final Action moveChannelsUp = new MoveChannelsUp();
    public final Action moveChannelsDown = new MoveChannelsDown();
    public final Action moveChannelsAtBottom = new MoveChannelsAtBottom();
    public final Action duplicateChannels = new DuplicateChannels();
    public final Action removeChannels = new RemoveChannels();
    public final Action selectAllChannels = new SelectAllChannels();
    public final Action deselectChannels = new DeselectChannels();
    public final Action browseOnlineTutorial = new BrowseOnlineTutorial();

    protected StdA4n() {
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    protected void exportSamplerConfig() {
        Object object;
        File file = StdUtils.showSaveLscpFileChooser();
        if (file == null) {
            return;
        }
        boolean bl = this.preferences().getBoolProperty("nativeFileChoosers");
        if (!(!file.exists() || CC.isMacOS() && bl)) {
            object = StdI18n.i18n.getMessage("StdA4n.overwriteFile?");
            if (!HF.showYesNoDialog(CC.getMainFrame(), (String)object)) {
                return;
            }
        }
        try {
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(JSUtils.exportSessionToLscpScript().getBytes("US-ASCII"));
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
            HF.showErrorMessage(exception);
        }
    }

    protected void exportMidiInstrumentMaps() {
        String string;
        File file = StdUtils.showSaveMidiMapsChooser();
        if (file == null) {
            return;
        }
        boolean bl = this.preferences().getBoolProperty("nativeFileChoosers");
        if (!(!file.exists() || CC.isMacOS() && bl)) {
            string = StdI18n.i18n.getMessage("StdA4n.overwriteFile?");
            if (!HF.showYesNoDialog(CC.getMainFrame(), string)) {
                return;
            }
        }
        string = "";
        int n = file.getName().lastIndexOf(46);
        if (n != -1) {
            string = file.getName().substring(n).toLowerCase();
        }
        try {
            FileOutputStream fileOutputStream;
            if (string.equals(".lscp")) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(JSUtils.exportInstrMapsToLscpScript().getBytes("US-ASCII"));
            } else if (string.equals(".txt")) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(JSUtils.exportInstrMapsToText().getBytes("US-ASCII"));
            } else if (string.equals(".htm") || string.equals(".html")) {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(JSUtils.exportInstrMapsToHtml().getBytes("US-ASCII"));
            } else if (string.equals(".rgd")) {
                byte[] byArray = JSUtils.exportInstrMapsToRGD();
                if (byArray == null) {
                    String string2 = StdI18n.i18n.getError("StdA4n.rgdExportFailed");
                    HF.showErrorMessage(string2);
                    return;
                }
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
            } else {
                if ((file = new File(file.getAbsolutePath() + ".lscp")).exists()) {
                    String string3 = StdI18n.i18n.getError("StdA4n.fileExists", file.getAbsolutePath());
                    HF.showErrorMessage(string3);
                    return;
                }
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(JSUtils.exportInstrMapsToLscpScript().getBytes("US-ASCII"));
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
            HF.showErrorMessage(exception);
        }
    }

    public static void updateLoadInstrumentMenu(final JMenu jMenu, final LoadInstrumentActionFactory loadInstrumentActionFactory) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StdA4n.updateLoadInstrumentMenu0(jMenu, loadInstrumentActionFactory);
            }
        });
    }

    private static void updateLoadInstrumentMenu0(JMenu jMenu, LoadInstrumentActionFactory loadInstrumentActionFactory) {
        Object object;
        int n;
        if (CC.getMainFrame() == null) {
            return;
        }
        jMenu.removeAll();
        int n2 = 0;
        JSChannelsPane jSChannelsPane = null;
        for (n = 0; n < CC.getMainFrame().getChannelsPaneCount(); ++n) {
            if (CC.getMainFrame().getChannelsPane(n).getChannelCount() == 0) continue;
            jSChannelsPane = CC.getMainFrame().getChannelsPane(n);
            ++n2;
            object = "instrumentsdb.actions.loadInstrument.onPanel";
            JMenu jMenu2 = new JMenu(StdI18n.i18n.getMenuLabel((String)object, n + 1));
            for (int i = 0; i < jSChannelsPane.getChannelCount(); ++i) {
                SamplerChannelModel samplerChannelModel = jSChannelsPane.getChannel(i).getModel();
                jMenu2.add(new JMenuItem(loadInstrumentActionFactory.createLoadInstrumentAction(samplerChannelModel, true)));
            }
            jMenu.add(jMenu2);
        }
        if (n2 == 1 && CC.getMainFrame().getSelectedChannelsPane() == jSChannelsPane) {
            jMenu.removeAll();
            for (n = 0; n < jSChannelsPane.getChannelCount(); ++n) {
                object = jSChannelsPane.getChannel(n).getModel();
                jMenu.add(new JMenuItem(loadInstrumentActionFactory.createLoadInstrumentAction((SamplerChannelModel)object, false)));
            }
        }
    }

    public static interface LoadInstrumentActionFactory {
        public LoadInstrumentAction createLoadInstrumentAction(SamplerChannelModel var1, boolean var2);
    }

    public static abstract class LoadInstrumentAction
    extends AbstractAction {
        protected final SamplerChannelModel channelModel;

        LoadInstrumentAction(SamplerChannelModel samplerChannelModel) {
            this(samplerChannelModel, false);
        }

        LoadInstrumentAction(SamplerChannelModel samplerChannelModel, boolean bl) {
            String string = bl ? "instrumentsdb.actions.loadInstrument.onPanel.channel" : "instrumentsdb.actions.loadInstrument.onChannel";
            int n = CC.getMainFrame().getChannelNumber(samplerChannelModel) + 1;
            this.putValue("Name", StdI18n.i18n.getMenuLabel(string, n));
            this.channelModel = samplerChannelModel;
        }
    }

    private class BrowseOnlineTutorial
    extends AbstractAction {
        BrowseOnlineTutorial() {
            super(StdI18n.i18n.getMenuLabel("help.onlineTutorial"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("help.onlineTutorial.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StdUtils.browse("http://jsampler.sourceforge.net/");
        }
    }

    private static class DeselectChannels
    extends AbstractAction {
        DeselectChannels() {
            super(StdI18n.i18n.getMenuLabel("channels.selectNone"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.selectNone.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.getMainFrame().getSelectedChannelsPane().clearSelection();
        }
    }

    private static class SelectAllChannels
    extends AbstractAction {
        SelectAllChannels() {
            super(StdI18n.i18n.getMenuLabel("channels.selectAll"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.selectAll.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.getMainFrame().getSelectedChannelsPane().selectAll();
        }
    }

    public static class MoveChannelsToPanel
    extends AbstractAction
    implements ListSelectionListener {
        private final JSChannelsPane pane;

        public MoveChannelsToPanel(JSChannelsPane jSChannelsPane) {
            super(jSChannelsPane.getTitle());
            this.pane = jSChannelsPane;
            CC.getMainFrame().addChannelsPaneSelectionListener(this);
            this.valueChanged(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannel[] jSChannelArray;
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            for (JSChannel jSChannel : jSChannelArray = jSChannelsPane.getSelectedChannels()) {
                jSChannelsPane.removeChannel(jSChannel);
            }
            this.pane.addChannels(jSChannelArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(CC.getMainFrame().getSelectedChannelsPane() != this.pane);
        }

        public JSChannelsPane getChannelsPane() {
            return this.pane;
        }
    }

    private static class RemoveChannels
    extends AbstractAction {
        RemoveChannels() {
            super(StdI18n.i18n.getMenuLabel("channels.removeChannel"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.removeChannels.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannel[] jSChannelArray;
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            if (jSChannelsPane.getSelectedChannelCount() > 1 && !HF.showYesNoDialog(CC.getMainFrame(), StdI18n.i18n.getMessage("StdA4n.removeChannels?"))) {
                return;
            }
            for (JSChannel jSChannel : jSChannelArray = jSChannelsPane.getSelectedChannels()) {
                this.removeChannel(jSChannel);
            }
        }

        private void removeChannel(JSChannel jSChannel) {
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            int n = jSChannel.getChannelInfo().getChannelId();
            CC.getSamplerModel().removeBackendChannel(n);
        }
    }

    private static class DuplicateChannels
    extends AbstractAction {
        DuplicateChannels() {
            super(StdI18n.i18n.getMenuLabel("channels.duplicate"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.duplicateChannels.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannel[] jSChannelArray = CC.getMainFrame().getSelectedChannelsPane().getSelectedChannels();
            if (jSChannelArray.length > 2 && !HF.showYesNoDialog(CC.getMainFrame(), StdI18n.i18n.getMessage("StdA4n.duplicateChannels?"))) {
                return;
            }
            CC.getTaskQueue().add(new org.jsampler.task.DuplicateChannels(jSChannelArray));
        }
    }

    private class MoveChannelsAtBottom
    extends AbstractAction {
        MoveChannelsAtBottom() {
            super(StdI18n.i18n.getMenuLabel("channels.moveAtBottom"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.moveAtBottom.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            jSChannelsPane.moveSelectedChannelsAtBottom();
        }
    }

    private class MoveChannelsDown
    extends AbstractAction {
        MoveChannelsDown() {
            super(StdI18n.i18n.getMenuLabel("channels.moveDown"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.moveDown.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            jSChannelsPane.moveSelectedChannelsDown();
        }
    }

    private class MoveChannelsUp
    extends AbstractAction {
        MoveChannelsUp() {
            super(StdI18n.i18n.getMenuLabel("channels.moveUp"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.moveUp.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            jSChannelsPane.moveSelectedChannelsUp();
        }
    }

    private class MoveChannelsOnTop
    extends AbstractAction {
        MoveChannelsOnTop() {
            super(StdI18n.i18n.getMenuLabel("channels.moveOnTop"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("channels.moveOnTop.tt"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
            jSChannelsPane.moveSelectedChannelsOnTop();
        }
    }

    private class ChangeBackend
    extends AbstractAction {
        ChangeBackend() {
            super(StdI18n.i18n.getMenuLabel("actions.changeBackend"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("actions.changeBackend.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.changeBackend();
        }
    }

    private class ExportMidiInstrumentMaps
    extends AbstractAction {
        ExportMidiInstrumentMaps() {
            super(StdI18n.i18n.getMenuLabel("actions.export.MidiInstrumentMaps"));
            String string = StdI18n.i18n.getMenuLabel("actions.export.MidiInstrumentMaps.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            StdA4n.this.exportMidiInstrumentMaps();
        }
    }

    private class ExportSamplerConfig
    extends AbstractAction {
        ExportSamplerConfig() {
            super(StdI18n.i18n.getMenuLabel("actions.export.samplerConfiguration"));
            String string = StdI18n.i18n.getMenuLabel("actions.export.samplerConfiguration.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            StdA4n.this.exportSamplerConfig();
        }
    }

    private class Reset
    extends AbstractAction {
        Reset() {
            super(StdI18n.i18n.getMenuLabel("actions.resetSampler"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("actions.resetSampler.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            String string = StdI18n.i18n.getMessage("StdA4n.resetSampler?");
            if (!HF.showYesNoDialog(CC.getMainFrame(), string)) {
                return;
            }
            CC.getSamplerModel().resetBackend();
        }
    }

    private class Refresh
    extends AbstractAction {
        Refresh() {
            super(StdI18n.i18n.getMenuLabel("actions.refresh"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("actions.refresh.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                CC.changeBackend();
                return;
            }
            CC.reconnect();
        }
    }

    private class Connect
    extends AbstractAction {
        Connect() {
            super(StdI18n.i18n.getMenuLabel("actions.connect"));
            this.putValue("ShortDescription", StdI18n.i18n.getMenuLabel("actions.connect.tt"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CC.reconnect();
        }
    }
}

