/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ApplicationState;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.KafkaStreamsState;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.assignment.TaskInfo;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.DefaultKafkaStreamsState;

public class DefaultApplicationState
implements ApplicationState {
    private final AssignmentConfigs assignmentConfigs;
    private final Map<TaskId, TaskInfo> tasks;
    private final Map<ProcessId, StreamsPartitionAssignor.ClientMetadata> clientStates;
    private final Map<Boolean, Map<ProcessId, KafkaStreamsState>> cachedKafkaStreamStates;

    public DefaultApplicationState(AssignmentConfigs assignmentConfigs, Map<TaskId, TaskInfo> tasks, Map<ProcessId, StreamsPartitionAssignor.ClientMetadata> clientStates) {
        this.assignmentConfigs = assignmentConfigs;
        this.tasks = Collections.unmodifiableMap(tasks);
        this.clientStates = clientStates;
        this.cachedKafkaStreamStates = new HashMap<Boolean, Map<ProcessId, KafkaStreamsState>>();
    }

    @Override
    public Map<ProcessId, KafkaStreamsState> kafkaStreamsStates(boolean computeTaskLags) {
        if (this.cachedKafkaStreamStates.containsKey(computeTaskLags)) {
            return this.cachedKafkaStreamStates.get(computeTaskLags);
        }
        HashMap<ProcessId, KafkaStreamsState> kafkaStreamsStates = new HashMap<ProcessId, KafkaStreamsState>();
        for (Map.Entry<ProcessId, StreamsPartitionAssignor.ClientMetadata> clientEntry : this.clientStates.entrySet()) {
            StreamsPartitionAssignor.ClientMetadata metadata = clientEntry.getValue();
            ClientState clientState = metadata.state();
            ProcessId processId = clientEntry.getKey();
            Map<TaskId, Long> taskLagTotals = computeTaskLags ? clientState.taskLagTotals() : null;
            DefaultKafkaStreamsState kafkaStreamsState = new DefaultKafkaStreamsState(processId, clientState.capacity(), clientState.clientTags(), clientState.previousActiveTasks(), clientState.previousStandbyTasks(), clientState.taskIdsByPreviousConsumer(), Optional.ofNullable(metadata.hostInfo()), Optional.ofNullable(taskLagTotals), metadata.rackId());
            kafkaStreamsStates.put(processId, kafkaStreamsState);
        }
        this.cachedKafkaStreamStates.put(computeTaskLags, kafkaStreamsStates);
        return kafkaStreamsStates;
    }

    @Override
    public AssignmentConfigs assignmentConfigs() {
        return this.assignmentConfigs;
    }

    @Override
    public Map<TaskId, TaskInfo> allTasks() {
        return this.tasks;
    }
}

