/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.server.common.ApiMessageAndVersion;

final class ControllerResultAndOffset<T>
extends ControllerResult<T> {
    private final long offset;

    private ControllerResultAndOffset(long offset, ControllerResult<T> result) {
        super(result.records(), result.response(), result.isAtomic());
        this.offset = offset;
    }

    public long offset() {
        return this.offset;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ControllerResultAndOffset other = (ControllerResultAndOffset)o;
        return this.records().equals(other.records()) && this.response().equals(other.response()) && this.isAtomic() == other.isAtomic() && this.offset == other.offset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.records(), this.response(), this.isAtomic(), this.offset);
    }

    @Override
    public String toString() {
        return String.format("ControllerResultAndOffset(records=%s, response=%s, isAtomic=%s, offset=%d)", this.records().stream().map(ApiMessageAndVersion::toString).collect(Collectors.joining(",")), this.response(), this.isAtomic(), this.offset);
    }

    public static <T> ControllerResultAndOffset<T> of(long offset, ControllerResult<T> result) {
        return new ControllerResultAndOffset<T>(offset, result);
    }
}

