/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.groovy.Bundle;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;

public class GroovySourcesImpl
implements Sources,
SourceGroupModifierImplementation {
    public static final String TYPE_GROOVY = "groovy";
    public static final String NAME_GROOVYSOURCE = "81GroovySourceRoot";
    public static final String NAME_GROOVYTESTSOURCE = "82GroovyTestSourceRoot";
    private final Project project;

    public GroovySourcesImpl(Project project) {
        this.project = project;
    }

    public SourceGroup[] getSourceGroups(String type) {
        if (TYPE_GROOVY.equals(type)) {
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            this.addTestGroup(groups);
            this.addSourcesGroup(groups);
            return groups.toArray(new SourceGroup[0]);
        }
        return new SourceGroup[0];
    }

    private void addTestGroup(List<SourceGroup> groups) {
        this.addGroupIfRootExists(groups, "test", NAME_GROOVYTESTSOURCE, Bundle.SG_Test_GroovySources());
    }

    private void addSourcesGroup(List<SourceGroup> groups) {
        this.addGroupIfRootExists(groups, "main", NAME_GROOVYSOURCE, Bundle.SG_GroovySources());
    }

    private void addGroupIfRootExists(List<SourceGroup> groups, String rootType, String name, String displayName) {
        FileObject root = this.project.getProjectDirectory().getFileObject("src/" + rootType + "/groovy");
        if (root != null) {
            groups.add(GenericSources.group((Project)this.project, (FileObject)root, (String)name, (String)displayName, null, null));
        }
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public SourceGroup createSourceGroup(String type, String hint) {
        if (!this.canCreateSourceGroup(type, hint)) {
            return null;
        }
        ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
        if ("test".equals(hint)) {
            this.addTestGroup(groups);
        } else {
            this.addSourcesGroup(groups);
        }
        return groups.isEmpty() ? null : (SourceGroup)groups.get(0);
    }

    public boolean canCreateSourceGroup(String type, String hint) {
        return TYPE_GROOVY.equals(type) && ("main".equals(hint) || "test".equals(hint));
    }
}

