/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.InterceptorBindingVerifier;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

class InterceptorBindingChecker
extends RuntimeAnnotationChecker {
    private static final List<String> ANNOTATIONS = List.of("javax.interceptor.InterceptorBinding", "jakarta.interceptor.InterceptorBinding");

    InterceptorBindingChecker(AnnotationModelHelper helper) {
        this.init(null, helper);
    }

    void init(TypeElement element) {
        this.init((Element)element, this.getHelper());
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(InterceptorBindingChecker.class.getName());
    }

    @Override
    protected List<String> getAnnotation() {
        return ANNOTATIONS;
    }

    @Override
    public boolean hasReqiredTarget(AnnotationMirror target, Set<ElementType> set) {
        boolean hasRequiredTarget = super.hasReqiredTarget(target, set);
        if (!hasRequiredTarget) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Interceptor Binding but has wrong target values. Correct target values are {METHOD, TYPE} or or TYPE ");
        }
        return hasRequiredTarget;
    }

    @Override
    protected TargetVerifier getTargetVerifier() {
        return InterceptorBindingVerifier.getInstance();
    }

    void clean() {
        this.init(null, this.getHelper());
    }
}

