/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VolumeGroupBackup
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="expirationTime")
    private final Date expirationTime;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="sizeInMBs")
    private final Long sizeInMBs;
    @JsonProperty(value="sizeInGBs")
    private final Long sizeInGBs;
    @JsonProperty(value="sourceType")
    private final SourceType sourceType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeRequestReceived")
    private final Date timeRequestReceived;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="uniqueSizeInMbs")
    private final Long uniqueSizeInMbs;
    @JsonProperty(value="uniqueSizeInGbs")
    private final Long uniqueSizeInGbs;
    @JsonProperty(value="volumeBackupIds")
    private final List<String> volumeBackupIds;
    @JsonProperty(value="volumeGroupId")
    private final String volumeGroupId;
    @JsonProperty(value="sourceVolumeGroupBackupId")
    private final String sourceVolumeGroupBackupId;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "expirationTime", "freeformTags", "id", "lifecycleState", "sizeInMBs", "sizeInGBs", "sourceType", "timeCreated", "timeRequestReceived", "type", "uniqueSizeInMbs", "uniqueSizeInGbs", "volumeBackupIds", "volumeGroupId", "sourceVolumeGroupBackupId"})
    public VolumeGroupBackup(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Date expirationTime, Map<String, String> freeformTags, String id, LifecycleState lifecycleState, Long sizeInMBs, Long sizeInGBs, SourceType sourceType, Date timeCreated, Date timeRequestReceived, Type type, Long uniqueSizeInMbs, Long uniqueSizeInGbs, List<String> volumeBackupIds, String volumeGroupId, String sourceVolumeGroupBackupId) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.expirationTime = expirationTime;
        this.freeformTags = freeformTags;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.sizeInMBs = sizeInMBs;
        this.sizeInGBs = sizeInGBs;
        this.sourceType = sourceType;
        this.timeCreated = timeCreated;
        this.timeRequestReceived = timeRequestReceived;
        this.type = type;
        this.uniqueSizeInMbs = uniqueSizeInMbs;
        this.uniqueSizeInGbs = uniqueSizeInGbs;
        this.volumeBackupIds = volumeBackupIds;
        this.volumeGroupId = volumeGroupId;
        this.sourceVolumeGroupBackupId = sourceVolumeGroupBackupId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Long getSizeInMBs() {
        return this.sizeInMBs;
    }

    public Long getSizeInGBs() {
        return this.sizeInGBs;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeRequestReceived() {
        return this.timeRequestReceived;
    }

    public Type getType() {
        return this.type;
    }

    public Long getUniqueSizeInMbs() {
        return this.uniqueSizeInMbs;
    }

    public Long getUniqueSizeInGbs() {
        return this.uniqueSizeInGbs;
    }

    public List<String> getVolumeBackupIds() {
        return this.volumeBackupIds;
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public String getSourceVolumeGroupBackupId() {
        return this.sourceVolumeGroupBackupId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VolumeGroupBackup(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", expirationTime=").append(String.valueOf(this.expirationTime));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", sizeInMBs=").append(String.valueOf(this.sizeInMBs));
        sb.append(", sizeInGBs=").append(String.valueOf(this.sizeInGBs));
        sb.append(", sourceType=").append(String.valueOf((Object)this.sourceType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeRequestReceived=").append(String.valueOf(this.timeRequestReceived));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", uniqueSizeInMbs=").append(String.valueOf(this.uniqueSizeInMbs));
        sb.append(", uniqueSizeInGbs=").append(String.valueOf(this.uniqueSizeInGbs));
        sb.append(", volumeBackupIds=").append(String.valueOf(this.volumeBackupIds));
        sb.append(", volumeGroupId=").append(String.valueOf(this.volumeGroupId));
        sb.append(", sourceVolumeGroupBackupId=").append(String.valueOf(this.sourceVolumeGroupBackupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VolumeGroupBackup)) {
            return false;
        }
        VolumeGroupBackup other = (VolumeGroupBackup)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.expirationTime, other.expirationTime) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.sizeInMBs, other.sizeInMBs) && Objects.equals(this.sizeInGBs, other.sizeInGBs) && Objects.equals((Object)this.sourceType, (Object)other.sourceType) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeRequestReceived, other.timeRequestReceived) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.uniqueSizeInMbs, other.uniqueSizeInMbs) && Objects.equals(this.uniqueSizeInGbs, other.uniqueSizeInGbs) && Objects.equals(this.volumeBackupIds, other.volumeBackupIds) && Objects.equals(this.volumeGroupId, other.volumeGroupId) && Objects.equals(this.sourceVolumeGroupBackupId, other.sourceVolumeGroupBackupId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.expirationTime == null ? 43 : this.expirationTime.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sizeInMBs == null ? 43 : this.sizeInMBs.hashCode());
        result = result * 59 + (this.sizeInGBs == null ? 43 : this.sizeInGBs.hashCode());
        result = result * 59 + (this.sourceType == null ? 43 : this.sourceType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeRequestReceived == null ? 43 : this.timeRequestReceived.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.uniqueSizeInMbs == null ? 43 : this.uniqueSizeInMbs.hashCode());
        result = result * 59 + (this.uniqueSizeInGbs == null ? 43 : this.uniqueSizeInGbs.hashCode());
        result = result * 59 + (this.volumeBackupIds == null ? 43 : this.volumeBackupIds.hashCode());
        result = result * 59 + (this.volumeGroupId == null ? 43 : this.volumeGroupId.hashCode());
        result = result * 59 + (this.sourceVolumeGroupBackupId == null ? 43 : this.sourceVolumeGroupBackupId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Full("FULL"),
        Incremental("INCREMENTAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SourceType implements BmcEnum
    {
        Manual("MANUAL"),
        Scheduled("SCHEDULED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SourceType> map;

        private SourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SourceType.class);
            map = new HashMap<String, SourceType>();
            for (SourceType v : SourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Committed("COMMITTED"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Faulty("FAULTY"),
        RequestReceived("REQUEST_RECEIVED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="expirationTime")
        private Date expirationTime;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="sizeInMBs")
        private Long sizeInMBs;
        @JsonProperty(value="sizeInGBs")
        private Long sizeInGBs;
        @JsonProperty(value="sourceType")
        private SourceType sourceType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeRequestReceived")
        private Date timeRequestReceived;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="uniqueSizeInMbs")
        private Long uniqueSizeInMbs;
        @JsonProperty(value="uniqueSizeInGbs")
        private Long uniqueSizeInGbs;
        @JsonProperty(value="volumeBackupIds")
        private List<String> volumeBackupIds;
        @JsonProperty(value="volumeGroupId")
        private String volumeGroupId;
        @JsonProperty(value="sourceVolumeGroupBackupId")
        private String sourceVolumeGroupBackupId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder expirationTime(Date expirationTime) {
            this.expirationTime = expirationTime;
            this.__explicitlySet__.add("expirationTime");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder sizeInMBs(Long sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            this.__explicitlySet__.add("sizeInMBs");
            return this;
        }

        public Builder sizeInGBs(Long sizeInGBs) {
            this.sizeInGBs = sizeInGBs;
            this.__explicitlySet__.add("sizeInGBs");
            return this;
        }

        public Builder sourceType(SourceType sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeRequestReceived(Date timeRequestReceived) {
            this.timeRequestReceived = timeRequestReceived;
            this.__explicitlySet__.add("timeRequestReceived");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder uniqueSizeInMbs(Long uniqueSizeInMbs) {
            this.uniqueSizeInMbs = uniqueSizeInMbs;
            this.__explicitlySet__.add("uniqueSizeInMbs");
            return this;
        }

        public Builder uniqueSizeInGbs(Long uniqueSizeInGbs) {
            this.uniqueSizeInGbs = uniqueSizeInGbs;
            this.__explicitlySet__.add("uniqueSizeInGbs");
            return this;
        }

        public Builder volumeBackupIds(List<String> volumeBackupIds) {
            this.volumeBackupIds = volumeBackupIds;
            this.__explicitlySet__.add("volumeBackupIds");
            return this;
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            this.__explicitlySet__.add("volumeGroupId");
            return this;
        }

        public Builder sourceVolumeGroupBackupId(String sourceVolumeGroupBackupId) {
            this.sourceVolumeGroupBackupId = sourceVolumeGroupBackupId;
            this.__explicitlySet__.add("sourceVolumeGroupBackupId");
            return this;
        }

        public VolumeGroupBackup build() {
            VolumeGroupBackup model = new VolumeGroupBackup(this.compartmentId, this.definedTags, this.displayName, this.expirationTime, this.freeformTags, this.id, this.lifecycleState, this.sizeInMBs, this.sizeInGBs, this.sourceType, this.timeCreated, this.timeRequestReceived, this.type, this.uniqueSizeInMbs, this.uniqueSizeInGbs, this.volumeBackupIds, this.volumeGroupId, this.sourceVolumeGroupBackupId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VolumeGroupBackup model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("expirationTime")) {
                this.expirationTime(model.getExpirationTime());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("sizeInMBs")) {
                this.sizeInMBs(model.getSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("sizeInGBs")) {
                this.sizeInGBs(model.getSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("sourceType")) {
                this.sourceType(model.getSourceType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeRequestReceived")) {
                this.timeRequestReceived(model.getTimeRequestReceived());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("uniqueSizeInMbs")) {
                this.uniqueSizeInMbs(model.getUniqueSizeInMbs());
            }
            if (model.wasPropertyExplicitlySet("uniqueSizeInGbs")) {
                this.uniqueSizeInGbs(model.getUniqueSizeInGbs());
            }
            if (model.wasPropertyExplicitlySet("volumeBackupIds")) {
                this.volumeBackupIds(model.getVolumeBackupIds());
            }
            if (model.wasPropertyExplicitlySet("volumeGroupId")) {
                this.volumeGroupId(model.getVolumeGroupId());
            }
            if (model.wasPropertyExplicitlySet("sourceVolumeGroupBackupId")) {
                this.sourceVolumeGroupBackupId(model.getSourceVolumeGroupBackupId());
            }
            return this;
        }
    }
}

