/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrgRequest
extends BmcRequest<Void> {
    private String drgId;

    public String getDrgId() {
        return this.drgId;
    }

    public Builder toBuilder() {
        return new Builder().drgId(this.drgId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgId=").append(String.valueOf(this.drgId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrgRequest)) {
            return false;
        }
        GetDrgRequest other = (GetDrgRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgId, other.drgId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrgRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgId = null;

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrgRequest o) {
            this.drgId(o.getDrgId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrgRequest build() {
            GetDrgRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrgRequest buildWithoutInvocationCallback() {
            GetDrgRequest request = new GetDrgRequest();
            request.drgId = this.drgId;
            return request;
        }
    }
}

