/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpVariable;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.symfony.util.SymfonyUtils;
import org.openide.filesystems.FileObject;

public class SymfonyEditorExtender
extends EditorExtender {
    static final Logger LOGGER = Logger.getLogger(SymfonyEditorExtender.class.getName());
    private static final List<PhpBaseElement> ELEMENTS = Arrays.asList(new PhpVariable("$sf_user", new PhpClass("sfUser", "sfUser")), new PhpVariable("$sf_request", new PhpClass("sfWebRequest", "sfWebRequest")), new PhpVariable("$sf_response", new PhpClass("sfWebResponse", "sfWebResponse")));

    public List<PhpBaseElement> getElementsForCodeCompletion(FileObject fo) {
        if (SymfonyUtils.isView(fo)) {
            LinkedList<PhpBaseElement> elements = new LinkedList<PhpBaseElement>(ELEMENTS);
            elements.addAll(this.parseAction(fo));
            return elements;
        }
        return Collections.emptyList();
    }

    private PhpClass getPhpClass(PhpBaseElement element) {
        String fqn = element.getFullyQualifiedName();
        if (fqn == null) {
            return null;
        }
        return new PhpClass(element.getName(), fqn);
    }

    private Set<PhpVariable> parseAction(final FileObject view) {
        assert (SymfonyUtils.isView(view)) : "Not a view: " + view;
        FileObject action = SymfonyUtils.getAction(view);
        if (action == null) {
            return Collections.emptySet();
        }
        for (PhpBaseElement phpBaseElement : ELEMENTS) {
            phpBaseElement.setFile(action);
        }
        final HashSet<PhpVariable> phpVariables = new HashSet<PhpVariable>();
        try {
            ParserManager.parse(Collections.singleton(Source.create((FileObject)action)), (UserTask)new UserTask(this){
                final /* synthetic */ SymfonyEditorExtender this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    ParserResult parseResult = (ParserResult)resultIterator.getParserResult();
                    SymfonyControllerVisitor controllerVisitor = new SymfonyControllerVisitor(view, (PHPParseResult)parseResult);
                    controllerVisitor.scan((ASTNode)Utils.getRoot((ParserResult)parseResult));
                    phpVariables.addAll(controllerVisitor.getPhpVariables());
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return phpVariables;
    }

    private static final class SymfonyControllerVisitor
    extends DefaultVisitor {
        private final String actionName;
        private final FileObject action;
        private final PHPParseResult actionParseResult;
        private final Set<PhpVariable> fields = new HashSet<PhpVariable>();
        private String className = null;
        private String methodName = null;

        public SymfonyControllerVisitor(FileObject view, PHPParseResult actionParseResult) {
            assert (view != null);
            assert (actionParseResult != null);
            this.actionParseResult = actionParseResult;
            this.actionName = SymfonyUtils.getActionName(view);
            this.action = SymfonyUtils.getAction(view);
        }

        public void visit(ClassDeclaration node) {
            this.className = CodeUtils.extractClassName((ClassDeclaration)node).toLowerCase();
            super.visit(node);
        }

        public void visit(MethodDeclaration node) {
            this.methodName = CodeUtils.extractMethodName((MethodDeclaration)node).toLowerCase();
            super.visit(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(Assignment assignment) {
            super.visit(assignment);
            if (assignment.getLeftHandSide() instanceof FieldAccess) {
                FieldAccess node = (FieldAccess)assignment.getLeftHandSide();
                if (this.action != null && this.className != null && this.methodName != null && this.className.endsWith("actions") && this.methodName.equals(this.actionName) && node.getDispatcher() instanceof Variable && "$this".equals(CodeUtils.extractVariableName((Variable)((Variable)node.getDispatcher())))) {
                    String name = null;
                    String fqn = null;
                    Iterator iterator = ModelUtils.resolveType((Model)this.actionParseResult.getModel(), (Assignment)assignment).iterator();
                    if (iterator.hasNext()) {
                        TypeScope typeScope = (TypeScope)iterator.next();
                        name = typeScope.getName();
                        fqn = typeScope.getFullyQualifiedName().toString();
                    }
                    Variable field = node.getField();
                    Set<PhpVariable> set = this.fields;
                    synchronized (set) {
                        PhpVariable phpVariable = new PhpVariable("$" + CodeUtils.extractVariableName((Variable)field), name != null ? new PhpClass(name, fqn) : null, this.action, ASTNodeInfo.toOffsetRangeVar((Variable)field).getStart());
                        phpVariable.setFile(this.action);
                        this.fields.add(phpVariable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<PhpVariable> getPhpVariables() {
            HashSet<PhpVariable> phpVariables = new HashSet<PhpVariable>();
            Set<PhpVariable> set = this.fields;
            synchronized (set) {
                phpVariables.addAll(this.fields);
            }
            return phpVariables;
        }
    }
}

