/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.url.Url;

abstract class Arrow
extends GraphicalElement
implements InGroupable {
    private final Rose skin;
    private final ArrowComponent arrowComponent;
    private double paddingArrowHead;
    private double maxX;
    private final Url url;
    private final Pragma pragma;
    private final String uid;

    public void setMaxX(double m) {
        if (this.maxX != 0.0) {
            throw new IllegalStateException();
        }
        this.maxX = m;
    }

    protected final double getMaxX() {
        if (this.maxX == 0.0) {
            // empty if block
        }
        return this.maxX;
    }

    public abstract double getActualWidth(StringBounder var1);

    Arrow(AtomicInteger counter, Pragma pragma, double startingY, Rose skin, ArrowComponent arrowComponent, Url url) {
        super(startingY);
        this.pragma = pragma;
        this.skin = skin;
        this.arrowComponent = arrowComponent;
        this.url = url;
        this.uid = "msg" + counter.getAndAdd(1);
    }

    protected Url getUrl() {
        return this.url;
    }

    protected final void startGroup(UGraphic ug) {
        UGroup typeIdents = new UGroup();
        typeIdents.put(UGroupType.CLASS, "message");
        typeIdents.put(UGroupType.DATA_PARTICIPANT_1, this.getParticipant1().getUid());
        typeIdents.put(UGroupType.DATA_PARTICIPANT_2, this.getParticipant2().getUid());
        typeIdents.put(UGroupType.DATA_UID, this.uid);
        ug.startGroup(typeIdents);
    }

    protected final void endGroup(UGraphic ug) {
        ug.closeGroup();
    }

    protected final void startUrl(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
    }

    protected final void endUrl(UGraphic ug) {
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    public abstract int getDirection(StringBounder var1);

    protected Rose getSkin() {
        return this.skin;
    }

    protected final ArrowComponent getArrowComponent() {
        return this.arrowComponent;
    }

    public double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    public abstract double getArrowYStartLevel(StringBounder var1);

    public abstract double getArrowYEndLevel(StringBounder var1);

    public abstract LivingParticipantBox getParticipantAt(StringBounder var1, NotePosition var2);

    protected abstract Participant getParticipant1();

    protected abstract Participant getParticipant2();

    protected final double getPaddingArrowHead() {
        return this.paddingArrowHead;
    }

    protected final void setPaddingArrowHead(double paddingArrowHead) {
        this.paddingArrowHead = paddingArrowHead;
    }

    public final double getMargin() {
        return 5.0;
    }
}

