/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGAnimatedPathDataSupport;
import org.apache.batik.dom.svg.SVGOMAnimatedPathData;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGPathContext;
import org.apache.batik.ext.awt.geom.PathLength;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge
implements SVGPathContext {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();
    protected Shape pathLengthShape;
    protected PathLength pathLength;

    public String getLocalName() {
        return "path";
    }

    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        SVGOMPathElement sVGOMPathElement = (SVGOMPathElement)element;
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        try {
            SVGOMAnimatedPathData sVGOMAnimatedPathData = sVGOMPathElement.getAnimatedPathData();
            sVGOMAnimatedPathData.check();
            SVGPathSegList sVGPathSegList = sVGOMAnimatedPathData.getAnimatedPathSegList();
            aWTPathProducer.setWindingRule(CSSUtilities.convertFillRule(element));
            SVGAnimatedPathDataSupport.handlePathSegList(sVGPathSegList, aWTPathProducer);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
        finally {
            shapeNode.setShape(aWTPathProducer.getShape());
        }
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        if (animatedLiveAttributeValue.getNamespaceURI() == null && animatedLiveAttributeValue.getLocalName().equals("d")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected PathLength getPathLengthObj() {
        Shape shape = ((ShapeNode)this.node).getShape();
        if (this.pathLengthShape != shape) {
            this.pathLength = new PathLength(shape);
            this.pathLengthShape = shape;
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.lengthOfPath();
    }

    public Point2D getPointAtLength(float f) {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.pointAtLength(f);
    }

    public int getPathSegAtLength(float f) {
        PathLength pathLength = this.getPathLengthObj();
        return pathLength.segmentAtLength(f);
    }
}

