/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.lang;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangCodesResource {
    private static final Logger logger = LoggerFactory.getLogger(LangCodesResource.class);
    private static final String LANG_CODE_COL = "langCode";
    private static final String DESCRIPTION_COL = "description";
    private static final String LANGUAGE_CODES_CSV_PATH = "/language-codes.csv";
    private static ImmutableList<LangCode> cachedLangCodes;

    public static ImmutableList<LangCode> getLangCodes() {
        return cachedLangCodes;
    }

    private static ImmutableList<LangCode> loadLangCodes() throws IOException {
        CsvSchema schema = CsvSchema.builder().addColumn(LANG_CODE_COL).addColumn(DESCRIPTION_COL).build();
        CsvMapper mapper = new CsvMapper();
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        URL langCodesUrl = LangCodeRegistry.class.getResource(LANGUAGE_CODES_CSV_PATH);
        MappingIterator iterator = mapper.readerFor(LangCode.class).with(schema).readValues(langCodesUrl);
        ImmutableList.Builder langCodeListBuilder = ImmutableList.builder();
        while (iterator.hasNext()) {
            langCodeListBuilder.add((Object)((LangCode)iterator.next()));
        }
        ImmutableList langCodeList = langCodeListBuilder.build();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        langCodeList.forEach(lc -> builder.put((Object)lc.getLangCode().toLowerCase(), lc));
        return langCodeList;
    }

    static {
        try {
            cachedLangCodes = LangCodesResource.loadLangCodes();
        }
        catch (IOException e) {
            logger.error("Could not load lang codes: {}", (Object)e.getMessage(), (Object)e);
            cachedLangCodes = ImmutableList.of();
        }
    }
}

