/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.change.MakeClassesMutuallyDisjoint;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class MakePrimitiveSubClassesMutuallyDisjoint
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public MakePrimitiveSubClassesMutuallyDisjoint(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass cls, @Nonnull OWLOntology targetOntology) {
        this(dataFactory, cls, targetOntology, false);
    }

    public MakePrimitiveSubClassesMutuallyDisjoint(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass cls, @Nonnull OWLOntology targetOntology, boolean usePairwiseDisjointAxioms) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(cls, "cls cannot be null"), OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), usePairwiseDisjointAxioms);
    }

    private void generateChanges(@Nonnull OWLClass cls, @Nonnull OWLOntology targetOntology, boolean usePairwiseDisjointAxioms) {
        HashSet<OWLClass> subclasses = new HashSet<OWLClass>();
        Collection<OWLClassExpression> sub = Searcher.sub(targetOntology.getSubClassAxiomsForSuperClass(cls), OWLClassExpression.class);
        for (OWLClassExpression subCls : sub) {
            if (subCls.isAnonymous() || EntitySearcher.isDefined(subCls.asOWLClass(), targetOntology)) continue;
            subclasses.add(subCls.asOWLClass());
        }
        MakeClassesMutuallyDisjoint makeClassesMutuallyDisjoint = new MakeClassesMutuallyDisjoint(this.getDataFactory(), subclasses, usePairwiseDisjointAxioms, targetOntology);
        this.addChanges(makeClassesMutuallyDisjoint.getChanges());
    }
}

