/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.SQLNewScriptTemplateVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeDriver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeProvider;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLEditorUtils {
    private static final Log log = Log.getLog(SQLEditorUtils.class);
    public static final String SCRIPT_FILE_EXTENSION = "sql";
    private static final String DISABLE_SQL_SYNTAX_PARSER_RESOURCE_PROPERTY = "disable-sql-syntax-parser";
    private static final int MIN_SQL_DESCRIPTION_LENGTH = 512;
    private static final QualifiedName NEW_SCRIPT_FILE = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql", "newScriptFile");

    public static boolean isOpenSeparateConnection(DBPDataSourceContainer container) {
        ModelPreferences.SeparateConnectionBehavior behavior = ModelPreferences.SeparateConnectionBehavior.parse((String)container.getPreferenceStore().getString("database.editor.separate.connection"));
        switch (behavior) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return !container.isForceUseSingleConnection() && !container.getDriver().isEmbedded();
    }

    public static IFolder getScriptsFolder(DBPProject project, boolean forceCreate) throws CoreException {
        if (project == null) {
            Status status = new Status(4, "org.jkiss.dbeaver.ui.editors.sql", "No active project to locate Script Folder");
            throw new CoreException((IStatus)status);
        }
        return DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot(project, ScriptsHandlerImpl.class, forceCreate);
    }

    @Nullable
    public static ResourceInfo findRecentScript(RCPProject project, @Nullable SQLNavigatorContext context) throws CoreException {
        ArrayList<ResourceInfo> scripts = new ArrayList<ResourceInfo>();
        SQLEditorUtils.findScriptList(project, SQLEditorUtils.getScriptsFolder((DBPProject)project, false), context == null ? null : context.getDataSourceContainer(), scripts);
        long recentTimestamp = 0L;
        ResourceInfo recentFile = null;
        for (ResourceInfo file : scripts) {
            long lastModified;
            if (file.resource == null || (lastModified = ResourceUtils.getResourceLastModified((IResource)file.resource)) <= recentTimestamp) continue;
            recentTimestamp = lastModified;
            recentFile = file;
        }
        return recentFile;
    }

    private static void findScriptList(@NotNull RCPProject project, IFolder folder, @Nullable DBPDataSourceContainer container, @NotNull List<ResourceInfo> result) {
        if (folder == null || container == null) {
            return;
        }
        try {
            String[] stringArray = project.findResources(Map.of("default-datasource", container.getId()));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                IResource resource = project.getRootResource().findMember(path);
                if (resource instanceof IFile) {
                    result.add(new ResourceInfo((IFile)resource, container));
                }
                ++n2;
            }
            for (Map.Entry fileEntry : DBPPlatformDesktop.getInstance().getExternalFileManager().getAllFiles().entrySet()) {
                File extFile;
                if (!container.getId().equals(((Map)fileEntry.getValue()).get("sql-editor-data-source-id")) || !(extFile = new File((String)fileEntry.getKey())).exists()) continue;
                result.add(new ResourceInfo(extFile, container));
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage());
        }
    }

    public static List<ResourceInfo> findScriptTree(RCPProject project, IFolder folder, @Nullable DBPDataSourceContainer container) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        SQLEditorUtils.findScriptList(project, folder, container, result);
        return result;
    }

    @NotNull
    public static List<ResourceInfo> getScriptsFromProject(@NotNull RCPProject dbpProject) throws CoreException {
        IFolder resourceDefaultRoot = DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot((DBPProject)dbpProject, ScriptsHandlerImpl.class, false);
        if (resourceDefaultRoot != null) {
            return SQLEditorUtils.getScriptsFromFolder(resourceDefaultRoot);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<ResourceInfo> getScriptsFromFolder(@NotNull IFolder folder) throws CoreException {
        ArrayList<ResourceInfo> scripts = new ArrayList<ResourceInfo>();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFile) {
                IFile iFile = (IFile)member;
                ResourceInfo resourceInfo = new ResourceInfo(iFile, EditorUtils.getFileDataSource((IFile)iFile));
                scripts.add(resourceInfo);
            }
            if (member instanceof IFolder) {
                IFolder iFolder = (IFolder)member;
                scripts.addAll(SQLEditorUtils.getScriptsFromFolder(iFolder));
            }
            ++n2;
        }
        return scripts;
    }

    public static IFile createNewScript(DBPProject project, @Nullable IFolder folder, @NotNull SQLNavigatorContext navigatorContext) throws CoreException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IFolder scriptsRootFolder = SQLEditorUtils.getScriptsFolder(project, true);
        IFolder scriptsFolder = folder;
        if (scriptsFolder == null) {
            scriptsFolder = scriptsRootFolder;
        }
        if (!scriptsFolder.exists()) {
            scriptsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        DBPDataSourceContainer dataSourceContainer = navigatorContext.getDataSourceContainer();
        if (CommonUtils.equalObjects((Object)scriptsRootFolder, (Object)scriptsFolder) && dataSourceContainer != null) {
            IFolder dbFolder;
            DBPDataSourceFolder conFolder;
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.connection.folders") && (conFolder = dataSourceContainer.getFolder()) != null) {
                ArrayList<DBPDataSourceFolder> conFolders = new ArrayList<DBPDataSourceFolder>();
                DBPDataSourceFolder f2 = conFolder;
                while (f2 != null) {
                    conFolders.add(0, f2);
                    f2 = f2.getParent();
                }
                for (DBPDataSourceFolder f2 : conFolders) {
                    IFolder dbFolder2 = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)f2.getName()));
                    if (dbFolder2 == null) continue;
                    if (!dbFolder2.exists()) {
                        dbFolder2.create(true, true, (IProgressMonitor)progressMonitor);
                    }
                    scriptsFolder = dbFolder2;
                }
            }
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.folders") && (dbFolder = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)dataSourceContainer.getName()))) != null) {
                if (!dbFolder.exists()) {
                    dbFolder.create(true, true, (IProgressMonitor)progressMonitor);
                }
                scriptsFolder = dbFolder;
            }
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String pattern = store.getString("script.file.name.pattern");
        String filename = GeneralUtils.replaceVariables((String)pattern, (IVariableResolver)new SQLEditorVariablesResolver(dataSourceContainer, dataSourceContainer == null ? null : dataSourceContainer.getConnectionConfiguration(), navigatorContext.getExecutionContext(), null, null, null));
        IFile tempFile = ResourceUtils.getUniqueFile((IFolder)scriptsFolder, (String)(CommonUtils.isEmpty((String)filename) ? "Script" : CommonUtils.escapeFileName((String)filename)), (String)SCRIPT_FILE_EXTENSION);
        tempFile.create((InputStream)new ByteArrayInputStream(SQLEditorUtils.getResolvedNewScriptTemplate(dataSourceContainer).getBytes(StandardCharsets.UTF_8)), true, (IProgressMonitor)progressMonitor);
        tempFile.setSessionProperty(NEW_SCRIPT_FILE, (Object)true);
        if (navigatorContext.getDataSourceContainer() != null) {
            EditorUtils.setFileDataSource((IFile)tempFile, (DatabaseEditorContext)navigatorContext);
        }
        return tempFile;
    }

    public static String getResourceDescription(IResource resource) {
        if (resource instanceof IFolder) {
            return "";
        }
        if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
            String description = SQLEditorUtils.getScriptDescription((IFile)resource);
            if (CommonUtils.isEmptyTrimmed((String)description)) {
                description = "<empty>";
            }
            return description;
        }
        return "";
    }

    public static boolean isNewScriptFile(@NotNull IResource resource) {
        try {
            return Boolean.TRUE.equals(resource.getSessionProperty(NEW_SCRIPT_FILE));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @NotNull
    public static String getNewScriptTemplate(@NotNull DBPPreferenceStore store) {
        return store.getString("new.script.template");
    }

    @NotNull
    public static String getResolvedNewScriptTemplate(@Nullable DBPDataSourceContainer container) {
        DBPPreferenceStore store;
        if (container != null && (store = container.getPreferenceStore()).getBoolean("new.script.template.enabled")) {
            return GeneralUtils.replaceVariables((String)SQLEditorUtils.getNewScriptTemplate(store), (IVariableResolver)new SQLNewScriptTemplateVariablesResolver(container, container.getConnectionConfiguration()));
        }
        return "";
    }

    public static IContentType getSQLContentType() {
        return Platform.getContentTypeManager().getContentType("org.jkiss.dbeaver.sql");
    }

    @Nullable
    public static String getScriptDescription(@NotNull IFile sqlScript) {
        try {
            StringBuilder sql = new StringBuilder();
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader is = new BufferedReader(new InputStreamReader(sqlScript.getContents()));){
                String line;
                while ((line = is.readLine()) != null) {
                    if ((line = line.trim()).startsWith("--") || line.startsWith("Rem") || line.startsWith("rem") || line.startsWith("REM")) continue;
                    sql.append(line).append('\n');
                    if (sql.length() > 512) break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return SQLUtils.getScriptDescription((String)sql.toString());
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public static boolean isSQLSyntaxParserApplied(@Nullable IEditorInput input) {
        return SQLEditorUtils.isSQLSyntaxParserEnabled(input) && !SQLEditorBase.isBigScript(input);
    }

    public static boolean isSQLSyntaxParserEnabled(@Nullable IEditorInput input) {
        EditorFileInfo file = EditorFileInfo.getFromEditor(input);
        if (file != null) {
            try {
                return !CommonUtils.getBoolean((Object)file.getPropertyValue(DISABLE_SQL_SYNTAX_PARSER_RESOURCE_PROPERTY), (boolean)false);
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return true;
    }

    public static void setSQLSyntaxParserEnabled(@Nullable IEditorInput input, boolean value) {
        EditorFileInfo file = EditorFileInfo.getFromEditor(input);
        if (file != null) {
            try {
                file.setPropertyValue(DISABLE_SQL_SYNTAX_PARSER_RESOURCE_PROPERTY, Boolean.toString(!value));
                SQLEditorUtils.notifyAssociatedServices(file, value);
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    private static void notifyAssociatedServices(@NotNull EditorFileInfo file, boolean newServicesEnabled) {
        HashSet<DBPPreferenceStore> affectedPrefs = new HashSet<DBPPreferenceStore>();
        LinkedList<SQLEditor> affectedEditors = new LinkedList<SQLEditor>();
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    IEditorPart editor = editorRef.getEditor(false);
                    if (editor instanceof SQLEditorBase) {
                        SQLEditorBase sqlEditor = (SQLEditorBase)editor;
                        EditorFileInfo editorFile = EditorFileInfo.getFromEditor(editor.getEditorInput());
                        if (editorFile != null && editorFile.equals(file)) {
                            affectedPrefs.add(sqlEditor.getActivePreferenceStore());
                            if (editor instanceof SQLEditor) {
                                affectedEditors.add((SQLEditor)editor);
                            }
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        for (DBPPreferenceStore prefs : affectedPrefs) {
            SQLEditorUtils.notifyPrefs(prefs, newServicesEnabled);
        }
        for (SQLEditor sqlEditor : affectedEditors) {
            sqlEditor.refreshEditorIconAndTitle();
            sqlEditor.refreshAdvancedServices();
        }
        ((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).refreshElements("org.jkiss.dbeaver.ui.editors.sql.disableSQLSyntaxParser", null);
    }

    private static void notifyPrefs(@NotNull DBPPreferenceStore prefStore, boolean newServicesEnabled) {
        boolean foldingEnabled = prefStore.getBoolean("SQLEditor.Folding.enabled");
        boolean autoActivationEnabled = prefStore.getBoolean("SQLEditor.ContentAssistant.auto.activation.enable");
        boolean markWordUnderCursorEnabled = prefStore.getBoolean("SQLEditor.markOccurrences");
        boolean markWordForSelectionEnabled = prefStore.getBoolean("SQLEditor.markOccurrences.forSelection");
        boolean oldServicesEnabled = !newServicesEnabled;
        prefStore.firePropertyChangeEvent("SQLEditor.Folding.enabled", (Object)(oldServicesEnabled && foldingEnabled ? 1 : 0), (Object)(newServicesEnabled && foldingEnabled ? 1 : 0));
        prefStore.firePropertyChangeEvent("SQLEditor.ContentAssistant.auto.activation.enable", (Object)(oldServicesEnabled && autoActivationEnabled ? 1 : 0), (Object)(newServicesEnabled && autoActivationEnabled ? 1 : 0));
        prefStore.firePropertyChangeEvent("SQLEditor.markOccurrences", (Object)(oldServicesEnabled && markWordUnderCursorEnabled ? 1 : 0), (Object)(newServicesEnabled && markWordUnderCursorEnabled ? 1 : 0));
        prefStore.firePropertyChangeEvent("SQLEditor.markOccurrences.forSelection", (Object)(oldServicesEnabled && markWordForSelectionEnabled ? 1 : 0), (Object)(newServicesEnabled && markWordForSelectionEnabled ? 1 : 0));
    }

    public static boolean isTemplateContextFitsEditorContext(@NotNull String templateContextTypeId, @NotNull SQLEditorBase editor) {
        String providerContextTypeId;
        DBPDriver driver;
        String driverContextTypeId;
        DBPDataSourceContainer dsContainer;
        boolean result = false;
        if (editor instanceof SQLEditor && (dsContainer = ((SQLEditor)editor).getDataSourceContainer()) != null && !(result = SQLEditorUtils.isTemplateContextFitsEditorContext(templateContextTypeId, driverContextTypeId = SQLContextTypeDriver.getTypeId(driver = dsContainer.getDriver()), providerContextTypeId = SQLContextTypeProvider.getTypeId(driver.getProviderId())))) {
            for (Pair replInfo : driver.getDriverReplacementsInfo()) {
                driverContextTypeId = SQLContextTypeDriver.getTypeId((String)replInfo.getFirst(), (String)replInfo.getSecond());
                result = SQLEditorUtils.isTemplateContextFitsEditorContext(templateContextTypeId, driverContextTypeId, providerContextTypeId);
                if (result) break;
            }
        }
        return result;
    }

    private static boolean isTemplateContextFitsEditorContext(@NotNull String templateContextTypeId, @Nullable String driverContextTypeId, @Nullable String providerContextTypeId) {
        return templateContextTypeId.equalsIgnoreCase(SCRIPT_FILE_EXTENSION) || templateContextTypeId.equalsIgnoreCase(driverContextTypeId) || templateContextTypeId.equalsIgnoreCase(providerContextTypeId);
    }

    public static boolean openNewSqlConsoleAndTryConnect(@NotNull DBPDataSourceContainer container, @NotNull Consumer<SQLEditor> onConnected) {
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            SQLEditor editor = (SQLEditor)((Object)serviceSQL.openSQLConsole(container, null, null, "Console", ""));
            EditorConnector connector = new EditorConnector(editor, container, onConnected);
            connector.engage();
            return true;
        }
        return false;
    }

    public static boolean isProblemMarker(@NotNull IMarker marker) {
        try {
            return marker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Nullable
    public static EditorsCollection findResourceEditors(@NotNull IResource member) {
        EditorsCollection editorRefs = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    try {
                        IResource editorResource = ResourceUtil.getResource((IEditorInput)editorRef.getEditorInput());
                        if (editorResource != null && editorResource.equals((Object)member)) {
                            if (editorRefs == null) {
                                editorRefs = new EditorsCollection();
                            }
                            editorRefs.add(Pair.of((Object)page, (Object)editorRef));
                        }
                    }
                    catch (PartInitException e) {
                        log.error((Object)e);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return editorRefs;
    }

    private static class EditorConnector {
        @NotNull
        private final SQLEditorListener editorListener = new SQLEditorListenerDefault(){

            @Override
            public void onDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
                this.onMaybeConnected();
            }
        };
        @NotNull
        private final SQLEditor editor;
        @NotNull
        private final DBPDataSourceContainer dataSourceContainer;
        @NotNull
        private final Consumer<SQLEditor> onConnectedHandler;
        private boolean isConnectionInitiated = false;
        private boolean isHandled = false;

        public EditorConnector(@NotNull SQLEditor editor, @NotNull DBPDataSourceContainer container, @NotNull Consumer<SQLEditor> onConnectedHandler) {
            this.editor = editor;
            this.dataSourceContainer = container;
            this.onConnectedHandler = onConnectedHandler;
            this.setup();
            editor.setDataSourceContainer(container);
        }

        public void engage() {
            UIUtils.asyncExec(() -> {
                boolean alreadyConnected;
                if (!this.isHandled && (alreadyConnected = this.editor.checkConnected(true, status -> UIUtils.asyncExec(() -> {
                    if (status.isOK()) {
                        this.onMaybeConnected();
                    }
                }))) && !this.editor.isDisposed()) {
                    this.onMaybeConnected();
                }
            });
        }

        private int countRelatedJobs() {
            return Job.getJobManager().find((Object)this.dataSourceContainer).length + Job.getJobManager().find((Object)this.editor).length;
        }

        private void onMaybeConnected() {
            UIUtils.asyncExec(() -> {
                int relatedJobsCount = this.countRelatedJobs();
                if (relatedJobsCount > 0) {
                    this.isConnectionInitiated = true;
                }
                if (!this.isHandled) {
                    DBCExecutionContext executionContext = this.editor.getExecutionContext();
                    if (executionContext != null) {
                        this.onFinished(true);
                    } else if (this.isConnectionInitiated && relatedJobsCount == 0) {
                        this.onFinished(false);
                    }
                }
            });
        }

        private void onFinished(boolean result) {
            this.isHandled = true;
            this.cleanup();
            if (!this.editor.isDisposed()) {
                this.onConnectedHandler.accept(result ? this.editor : null);
            }
        }

        private void setup() {
            this.editor.addListener(this.editorListener);
        }

        private void cleanup() {
            this.editor.removeListener(this.editorListener);
        }
    }

    private static abstract class EditorFileInfo {
        private EditorFileInfo() {
        }

        public abstract void setPropertyValue(@NotNull String var1, @NotNull Object var2);

        @Nullable
        public abstract Object getPropertyValue(@NotNull String var1);

        @Nullable
        public static EditorFileInfo getFromEditor(@Nullable IEditorInput input) {
            if (input != null) {
                IFile projectFile = EditorUtils.getFileFromInput((IEditorInput)input);
                if (projectFile != null) {
                    return new EditorProjectFileInfo(projectFile);
                }
                File platformFile = EditorUtils.getLocalFileFromInput((Object)input);
                if (platformFile != null) {
                    return new EditorPlatformFileInfo(platformFile);
                }
                return null;
            }
            return null;
        }
    }

    private static class EditorPlatformFileInfo
    extends EditorFileInfo {
        private final File platformFile;

        public EditorPlatformFileInfo(@Nullable File platformFile) {
            this.platformFile = platformFile;
        }

        @Override
        @Nullable
        public Object getPropertyValue(@NotNull String propertyName) {
            DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
            return efManager.getFileProperty(this.platformFile, propertyName);
        }

        @Override
        public void setPropertyValue(@NotNull String propertyName, @NotNull Object value) {
            DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
            efManager.setFileProperty(this.platformFile, propertyName, value);
        }

        public boolean equals(@Nullable Object obj) {
            EditorPlatformFileInfo other;
            EditorPlatformFileInfo editorPlatformFileInfo = other = obj instanceof EditorPlatformFileInfo ? (EditorPlatformFileInfo)obj : null;
            return other != null && this.platformFile != null && this.platformFile.equals(other.platformFile);
        }
    }

    private static class EditorProjectFileInfo
    extends EditorFileInfo {
        private final IFile projectFile;

        public EditorProjectFileInfo(@NotNull IFile projectFile) {
            this.projectFile = projectFile;
        }

        @Override
        @Nullable
        public Object getPropertyValue(@NotNull String propertyName) {
            RCPProject project = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(this.projectFile.getProject());
            if (project == null) {
                log.debug((Object)("Project '" + String.valueOf(this.projectFile.getProject()) + "' not recognized (property read)"));
                return null;
            }
            return EditorUtils.getResourceProperty((RCPProject)project, (IResource)this.projectFile, (String)propertyName);
        }

        @Override
        public void setPropertyValue(@NotNull String propertyName, @NotNull Object value) {
            RCPProject project = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(this.projectFile.getProject());
            if (project == null) {
                log.debug((Object)("Project '" + String.valueOf(this.projectFile.getProject()) + "' not recognized (property write)"));
                return;
            }
            EditorUtils.setResourceProperty((RCPProject)project, (IResource)this.projectFile, (String)propertyName, (Object)value);
        }

        public boolean equals(@Nullable Object obj) {
            EditorProjectFileInfo other;
            EditorProjectFileInfo editorProjectFileInfo = other = obj instanceof EditorProjectFileInfo ? (EditorProjectFileInfo)obj : null;
            return other != null && this.projectFile != null && this.projectFile.equals((Object)other.projectFile);
        }
    }

    public static class EditorsCollection
    extends LinkedList<Pair<IWorkbenchPage, IEditorReference>> {
        @NotNull
        public List<Pair<IWorkbenchPage, SQLEditor>> findConnectedSqlEditors() {
            LinkedList<Pair<IWorkbenchPage, SQLEditor>> results = new LinkedList<Pair<IWorkbenchPage, SQLEditor>>();
            for (Pair editorRef : this) {
                SQLEditor sqlEditor;
                IEditorPart editor = ((IEditorReference)editorRef.getSecond()).getEditor(false);
                if (!(editor instanceof SQLEditor) || (sqlEditor = (SQLEditor)editor).getDataSource() == null) continue;
                results.add((Pair<IWorkbenchPage, SQLEditor>)Pair.of((Object)((IWorkbenchPage)editorRef.getFirst()), (Object)((Object)sqlEditor)));
            }
            return results;
        }

        @NotNull
        public List<Pair<IWorkbenchPage, SQLEditor>> findNotConnectedSqlEditors() {
            LinkedList<Pair<IWorkbenchPage, SQLEditor>> results = new LinkedList<Pair<IWorkbenchPage, SQLEditor>>();
            for (Pair editorRef : this) {
                SQLEditor sqlEditor;
                DBPDataSourceContainer container;
                IEditorPart editor = ((IEditorReference)editorRef.getSecond()).getEditor(false);
                if (!(editor instanceof SQLEditor) || (container = (sqlEditor = (SQLEditor)editor).getDataSourceContainer()) != null && container.isConnected()) continue;
                results.add((Pair<IWorkbenchPage, SQLEditor>)Pair.of((Object)((IWorkbenchPage)editorRef.getFirst()), (Object)((Object)sqlEditor)));
            }
            return results;
        }

        public void validateEditorInputState() {
            for (Pair editorRef : this) {
                IEditorPart editor = ((IEditorReference)editorRef.getSecond()).getEditor(false);
                if (!(editor instanceof ITextEditorExtension2)) continue;
                UIUtils.asyncExec(() -> {
                    boolean bl = ((ITextEditorExtension2)editor).validateEditorInputState();
                });
            }
        }

        public void setDataSourceForSqlEditors(@NotNull DBPDataSourceContainer fileDsContainer) {
            for (Pair editorRef : this) {
                SQLEditor sqlEditor;
                DBPDataSourceContainer editorDsContainer;
                IEditorPart editor = ((IEditorReference)editorRef.getSecond()).getEditor(false);
                if (!(editor instanceof SQLEditor) || (editorDsContainer = (sqlEditor = (SQLEditor)editor).getDataSourceContainer()) == fileDsContainer) continue;
                UIUtils.asyncExec(() -> {
                    boolean bl = sqlEditor.setDataSourceContainer(fileDsContainer);
                });
                break;
            }
        }

        public void closeNoSave() {
            for (Pair editorRef : this) {
                ((IWorkbenchPage)editorRef.getFirst()).closeEditors(new IEditorReference[]{(IEditorReference)editorRef.getSecond()}, false);
            }
        }
    }

    public static class ResourceInfo {
        private final IResource resource;
        @Deprecated
        private final File localFile;
        private final DBPDataSourceContainer dataSource;
        private final List<ResourceInfo> children;
        private String description;

        ResourceInfo(IFile file, DBPDataSourceContainer dataSource) {
            this.resource = file;
            IPath location = file.getLocation();
            this.localFile = location == null ? null : location.toFile();
            this.dataSource = dataSource;
            this.children = null;
        }

        public ResourceInfo(IFolder folder) {
            this.resource = folder;
            IPath location = folder.getLocation();
            this.localFile = location == null ? null : location.toFile();
            this.dataSource = null;
            this.children = new ArrayList<ResourceInfo>();
        }

        ResourceInfo(File localFile, DBPDataSourceContainer dataSource) {
            this.resource = null;
            this.localFile = localFile;
            this.dataSource = dataSource;
            this.children = null;
        }

        public IResource getResource() {
            return this.resource;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public String getName() {
            return this.resource != null ? this.resource.getName() : this.localFile.getName();
        }

        public DBPDataSourceContainer getDataSource() {
            return this.dataSource;
        }

        public boolean isDirectory() {
            return this.resource instanceof IFolder;
        }

        public List<ResourceInfo> getChildren() {
            return this.children;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = SQLEditorUtils.getResourceDescription(this.resource);
            }
            return this.description;
        }

        public String toString() {
            return this.getName();
        }
    }
}

