/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposalContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SuggestionInformationControlCreator;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorQueryCompletionProposalContext;
import org.jkiss.utils.CommonUtils;

public class SQLEditorQueryCompletionProposal
extends SQLQueryCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private static final Log log = Log.getLog(SQLEditorQueryCompletionProposal.class);
    private final SQLEditorQueryCompletionProposalContext proposalContext;
    private Image cachedSwtImage = null;

    public SQLEditorQueryCompletionProposal(@NotNull SQLEditorQueryCompletionProposalContext proposalContext, @NotNull SQLQueryCompletionItemKind itemKind, @Nullable DBSObject object, @Nullable DBPImage image, @Nullable String displayString, @Nullable String decorationString, @NotNull String description, @NotNull String replacementString, int replacementOffset, int replacementLength, @Nullable SQLQueryWordEntry filterString, int proposalScore) {
        super((SQLQueryCompletionProposalContext)proposalContext, itemKind, object, image, displayString, decorationString, description, replacementString, replacementOffset, replacementLength, filterString, proposalScore);
        this.proposalContext = proposalContext;
    }

    @NotNull
    public SQLEditorQueryCompletionProposalContext getProposalContext() {
        return this.proposalContext;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return this.image == null ? null : (this.cachedSwtImage != null ? this.cachedSwtImage : (this.cachedSwtImage = DBeaverIcons.getImage((DBPImage)this.image)));
    }

    public StyledString getStyledDisplayString() {
        StyledString result = new StyledString(this.getDisplayString(), this.proposalContext.getStyler(this.itemKind));
        if (CommonUtils.isNotEmpty((String)this.decorationString)) {
            result.append(this.decorationString, StyledString.DECORATIONS_STYLER);
        }
        return result;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return this.object == null || !this.getProposalContext().getActivityTracker().isAdditionalInfoExpected() ? null : SuggestionInformationControlCreator.INSTANCE;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public Point getSelection(IDocument document) {
        return new Point(Math.min(this.replacementOffset + this.replacementString.length(), document.getLength()), 0);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.validate(document, offset, null)) {
            try {
                document.replace(this.replacementOffset, offset - this.replacementOffset, this.replacementString);
            }
            catch (BadLocationException ex) {
                log.error((Object)"Error applying completion proposal", (Throwable)ex);
            }
        }
    }
}

