/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.FileWatcher;
import org.gradle.fileevents.internal.WindowsFileEventFunctions;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.HierarchicalFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public class WindowsFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<WindowsFileEventFunctions, WindowsFileEventFunctions.WindowsFileWatcher> {
    private static final int BUFFER_SIZE = 65536;

    public WindowsFileWatcherRegistryFactory(AbstractFileWatcherRegistryFactory.FileEventFunctionsLookup fileEvents, Predicate<String> immutableLocationsFilter) throws NativeIntegrationUnavailableException {
        super(fileEvents.getFileEventFunctions(WindowsFileEventFunctions.class), immutableLocationsFilter);
    }

    @Override
    protected WindowsFileEventFunctions.WindowsFileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return (WindowsFileEventFunctions.WindowsFileWatcher)((WindowsFileEventFunctions)this.fileEventFunctions).newWatcher(fileEvents).withBufferSize(65536).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(WindowsFileEventFunctions.WindowsFileWatcher watcher, FileWatcherProbeRegistry probeRegistry, WatchableHierarchies watchableHierarchies) {
        return new HierarchicalFileWatcherUpdater((FileWatcher)watcher, HierarchicalFileWatcherUpdater.FileSystemLocationToWatchValidator.NO_VALIDATION, probeRegistry, watchableHierarchies, root -> watcher.stopWatchingMovedPaths());
    }
}

