/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileType;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;

public class NonIncrementalInputChanges
implements InputChangesInternal {
    private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> currentInputs;
    private final IncrementalInputProperties incrementalInputProperties;

    public NonIncrementalInputChanges(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> currentInputs, IncrementalInputProperties incrementalInputProperties) {
        this.currentInputs = currentInputs;
        this.incrementalInputProperties = incrementalInputProperties;
    }

    public boolean isIncremental() {
        return false;
    }

    public Iterable<FileChange> getFileChanges(FileCollection parameter) {
        return this.getObjectFileChanges(parameter);
    }

    public Iterable<FileChange> getFileChanges(Provider<? extends FileSystemLocation> parameter) {
        return this.getObjectFileChanges(parameter);
    }

    public Iterable<FileChange> getObjectFileChanges(Object parameter) {
        CurrentFileCollectionFingerprint currentFileCollectionFingerprint = (CurrentFileCollectionFingerprint)this.currentInputs.get((Object)this.incrementalInputProperties.getPropertyNameFor(parameter));
        Objects.requireNonNull(currentFileCollectionFingerprint);
        return () -> NonIncrementalInputChanges.getAllFileChanges(currentFileCollectionFingerprint).iterator();
    }

    @Override
    public Iterable<InputFileDetails> getAllFileChanges() {
        Iterable changes = () -> this.currentInputs.values().stream().flatMap(NonIncrementalInputChanges::getAllFileChanges).iterator();
        return (Iterable)Cast.uncheckedNonnullCast(changes);
    }

    private static Stream<FileChange> getAllFileChanges(CurrentFileCollectionFingerprint currentFileCollectionFingerprint) {
        return currentFileCollectionFingerprint.getFingerprints().entrySet().stream().map(entry -> new RebuildFileChange((String)entry.getKey(), ((FileSystemLocationFingerprint)entry.getValue()).getNormalizedPath(), ((FileSystemLocationFingerprint)entry.getValue()).getType()));
    }

    private static class RebuildFileChange
    implements FileChange,
    InputFileDetails {
        private final String path;
        private final String normalizedPath;
        private final org.gradle.internal.file.FileType fileType;

        public RebuildFileChange(String path, String normalizedPath, org.gradle.internal.file.FileType fileType) {
            this.path = path;
            this.normalizedPath = normalizedPath;
            this.fileType = fileType;
        }

        public File getFile() {
            return new File(this.path);
        }

        public ChangeType getChangeType() {
            return ChangeType.ADDED;
        }

        public FileType getFileType() {
            return DefaultFileChange.toPublicFileType(this.fileType);
        }

        public String getNormalizedPath() {
            return this.normalizedPath;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isModified() {
            return false;
        }

        public boolean isRemoved() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RebuildFileChange that = (RebuildFileChange)o;
            return this.path.equals(that.path) && this.normalizedPath.equals(that.normalizedPath);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.normalizedPath);
        }

        public String toString() {
            return "Input file " + this.path + " added for rebuild.";
        }
    }
}

