/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Extract a region of interest from the input image.


This filter produces an output image of the same dimension as the
input image. The user specifies the region of the input image that
will be contained in the output image. The origin coordinates of the
output images will be computed in such a way that if mapped to
physical space, the output image will overlay the input image with
perfect registration. In other words, a registration process between
the output image and the input image will return an identity
transform.

If you are interested in changing the dimension of the image, you may
want to consider the ExtractImageFilter . For example for extracting a 2D image from a slice of a 3D image.

The region to extract is set using the method SetRegionOfInterest.


See:
 ExtractImageFilter

 itk::simple::RegionOfInterest for the procedural interface

 itk::RegionOfInterestImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRegionOfInterestImageFilter.h
*/
public class RegionOfInterestImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RegionOfInterestImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RegionOfInterestImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RegionOfInterestImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RegionOfInterestImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RegionOfInterestImageFilter::~RegionOfInterestImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RegionOfInterestImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RegionOfInterestImageFilter::RegionOfInterestImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RegionOfInterestImageFilter() {
    this(SimpleITKJNI.new_RegionOfInterestImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RegionOfInterestImageFilter::SetSize(std::vector&lt; unsigned int &gt; Size)

Size in pixels of the region extracted.

*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.RegionOfInterestImageFilter_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::RegionOfInterestImageFilter::GetSize() const
*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.RegionOfInterestImageFilter_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::RegionOfInterestImageFilter::SetIndex(std::vector&lt; int &gt; Index)

Set the inclusive starting index of the region extracted.

*/
public  void setIndex(VectorInt32 Index) {
    SimpleITKJNI.RegionOfInterestImageFilter_setIndex(swigCPtr, this, VectorInt32.getCPtr(Index), Index);
  }

  /**
std::vector&lt;int&gt; itk::simple::RegionOfInterestImageFilter::GetIndex() const
*/
public  VectorInt32 getIndex() {
    return new VectorInt32(SimpleITKJNI.RegionOfInterestImageFilter_getIndex(swigCPtr, this), true);
  }

  /**
std::string itk::simple::RegionOfInterestImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RegionOfInterestImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RegionOfInterestImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RegionOfInterestImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RegionOfInterestImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.RegionOfInterestImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
void itk::simple::RegionOfInterestImageFilter::SetRegionOfInterest(const std::vector&lt; unsigned int &gt; &amp;Region)

Sets the region extracted by a single array of the starting indexes
followed by the sizes in pixels.

*/
public  void setRegionOfInterest(VectorUInt32 Region) {
    SimpleITKJNI.RegionOfInterestImageFilter_setRegionOfInterest(swigCPtr, this, VectorUInt32.getCPtr(Region), Region);
  }

}
