/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class RemoveCoordinatorStandard
implements RemoveCoordinator {
    private final CollectionMutationTarget mutationTarget;
    private final OperationProducer operationProducer;
    private final BasicBatchKey batchKey;
    private final MutationExecutorService mutationExecutorService;
    private MutationOperationGroup operationGroup;

    public RemoveCoordinatorStandard(CollectionMutationTarget mutationTarget, OperationProducer operationProducer, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.operationProducer = operationProducer;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#REMOVE");
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    public String toString() {
        return "RemoveCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getSqlString() {
        if (this.operationGroup == null) {
            this.operationGroup = this.buildOperationGroup();
        }
        JdbcMutationOperation operation = (JdbcMutationOperation)this.operationGroup.getSingleOperation();
        return operation.getSqlString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllRows(Object key, SharedSessionContractImplementor session) {
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Deleting collection - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        if (this.operationGroup == null) {
            this.operationGroup = this.buildOperationGroup();
        }
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> this.batchKey, this.operationGroup, session);
        try {
            JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
            ForeignKeyDescriptor fkDescriptor = this.mutationTarget.getTargetPart().getKeyDescriptor();
            fkDescriptor.getKeyPart().decompose(key, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
            mutationExecutor.execute(key, null, null, null, session);
        }
        finally {
            mutationExecutor.release();
        }
    }

    private MutationOperationGroup buildOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        CollectionTableMapping tableMapping = this.mutationTarget.getCollectionTableMapping();
        MutatingTableReference tableReference = new MutatingTableReference(tableMapping);
        return MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.mutationTarget, this.operationProducer.createOperation(tableReference));
    }
}

