/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerProto;

@Ignore(value="Requires local ML server")
public class GRPCRuleTest {
    public static final String RULE_ID = "REMOTE_ML_RULE";
    protected RemoteRuleConfig config;
    protected GRPCRule rule;

    @Before
    public void setUp() throws Exception {
        this.config = new RemoteRuleConfig();
        this.config.ruleId = RULE_ID;
        this.config.url = "localhost";
        this.config.port = 50000;
        this.rule = new GRPCRule(new Demo(), JLanguageTool.getMessageBundle(), this.config, true){

            protected String getMessage(MLServerProto.Match match, AnalyzedSentence sentence) {
                return "Matched: " + match.toString().replace("\n", " | ");
            }

            public String getId() {
                return GRPCRuleTest.RULE_ID;
            }

            public String getDescription() {
                return "Test rule";
            }
        };
    }

    @Test
    public void testMatch() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a test.");
        Arrays.asList(this.rule.match(s)).forEach(System.out::println);
    }

    @Test
    public void testMaxLength() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        AnalyzedSentence s = lt.getAnalyzedSentence("This is a test with size of more than 30 letters test.");
        List<RuleMatch> matches = Arrays.asList(this.rule.match(s));
        assert (matches.size() == 0);
    }
}

