/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;

class IvAlgorithmParameters
extends BaseAlgorithmParameters {
    private byte[] iv;

    IvAlgorithmParameters() {
    }

    @Override
    protected byte[] localGetEncoded() throws IOException {
        return new DEROctetString(this.iv).getEncoded();
    }

    @Override
    protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == IvParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
            return new IvParameterSpec(this.iv);
        }
        throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
        }
        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    @Override
    protected void localInit(byte[] byArray) throws IOException {
        try {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(byArray);
            this.iv = aSN1OctetString.getOctets();
        }
        catch (Exception exception) {
            throw new IOException("Exception decoding: " + exception);
        }
    }

    @Override
    protected String engineToString() {
        return "IV Parameters";
    }
}

