/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.dataframe.ColumnType;
import org.opensearch.ml.common.dataframe.ColumnValue;

public class LongValue
implements ColumnValue {
    private final long value;

    @Override
    public ColumnType columnType() {
        return ColumnType.LONG;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return Long.valueOf(this.value).doubleValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.columnType());
        out.writeLong(this.value);
    }

    @Generated
    public LongValue(long value) {
        this.value = value;
    }

    @Generated
    public String toString() {
        return "LongValue(value=" + String.valueOf(this.getValue()) + ")";
    }
}

