/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.dpop.verifiers;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofUse;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.singleuse.AlreadyUsedException;
import com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.net.URI;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class DPoPProofClaimsSetVerifier
extends DefaultJWTClaimsVerifier<DPoPProofContext> {
    private final long maxClockSkewSeconds;
    private final long maxAgeSeconds;
    private final SingleUseChecker<DPoPProofUse> singleUseChecker;
    @Deprecated
    private final SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> deprecatedSingleUseChecker;

    public DPoPProofClaimsSetVerifier(URI acceptedURI, String acceptedMethod, Nonce nonce, long maxClockSkewSeconds, long maxAgeSeconds, boolean requireATH, SingleUseChecker<DPoPProofUse> singleUseChecker) {
        super(null, DPoPProofClaimsSetVerifier.composeExpectedJWTClaimsSet(acceptedURI, acceptedMethod, nonce), new HashSet<String>(requireATH ? Arrays.asList("jti", "iat", "ath") : Arrays.asList("jti", "iat")), DPoPProofClaimsSetVerifier.composeProhibitedClaims(nonce));
        if (maxAgeSeconds < maxClockSkewSeconds) {
            throw new IllegalArgumentException("The iat max age must be greater than or equal to the iat max clock skew");
        }
        this.maxClockSkewSeconds = maxClockSkewSeconds;
        this.maxAgeSeconds = maxAgeSeconds;
        this.singleUseChecker = singleUseChecker;
        this.deprecatedSingleUseChecker = null;
    }

    @Deprecated
    public DPoPProofClaimsSetVerifier(URI acceptedURI, String acceptedMethod, Nonce nonce, long maxClockSkewSeconds, boolean requireATH, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        super(null, DPoPProofClaimsSetVerifier.composeExpectedJWTClaimsSet(acceptedURI, acceptedMethod, nonce), new HashSet<String>(requireATH ? Arrays.asList("jti", "iat", "ath") : Arrays.asList("jti", "iat")), DPoPProofClaimsSetVerifier.composeProhibitedClaims(nonce));
        this.maxClockSkewSeconds = maxClockSkewSeconds;
        this.maxAgeSeconds = 0L;
        this.singleUseChecker = null;
        this.deprecatedSingleUseChecker = singleUseChecker;
    }

    private static JWTClaimsSet composeExpectedJWTClaimsSet(URI uri, String method, Nonce nonce) {
        JWTClaimsSet.Builder b = new JWTClaimsSet.Builder().claim("htm", (Object)method).claim("htu", (Object)URIUtils.getBaseURI(uri).toString());
        if (nonce != null) {
            b = b.claim("nonce", (Object)nonce.getValue());
        }
        return b.build();
    }

    private static Set<String> composeProhibitedClaims(Nonce nonce) {
        return nonce == null ? Collections.singleton("nonce") : null;
    }

    public void verify(JWTClaimsSet claimsSet, DPoPProofContext context) throws BadJWTException {
        super.verify(claimsSet, (SecurityContext)context);
        Date iat = claimsSet.getIssueTime();
        Date now = new Date();
        long maxPastSecs = Math.max(this.maxClockSkewSeconds, this.maxAgeSeconds);
        Date maxPast = new Date(now.getTime() - maxPastSecs * 1000L);
        if (iat.before(maxPast)) {
            throw new BadJWTException("DPoP proof iat too old (>" + maxPastSecs + "s)");
        }
        Date maxFuture = new Date(now.getTime() + this.maxClockSkewSeconds * 1000L);
        if (iat.after(maxFuture)) {
            throw new BadJWTException("DPoP proof iat too far in future (>" + this.maxClockSkewSeconds + "s)");
        }
        if (this.singleUseChecker != null || this.deprecatedSingleUseChecker != null) {
            JWTID jti = new JWTID(claimsSet.getJWTID());
            try {
                if (this.singleUseChecker != null) {
                    this.singleUseChecker.markAsUsed(new DPoPProofUse(context.getIssuer(), jti, this.maxAgeSeconds));
                } else {
                    this.deprecatedSingleUseChecker.markAsUsed(new AbstractMap.SimpleImmutableEntry<DPoPIssuer, JWTID>(context.getIssuer(), jti));
                }
            }
            catch (AlreadyUsedException e) {
                throw new BadJWTException("The jti was already used in the past " + this.maxAgeSeconds + " seconds");
            }
        }
        if (this.getRequiredClaims().contains("ath")) {
            Base64URL ath;
            try {
                ath = new Base64URL(claimsSet.getStringClaim("ath"));
            }
            catch (ParseException e) {
                throw new BadJWTException("Invalid ath claim: " + e.getMessage(), (Throwable)e);
            }
            context.setAccessTokenHash(ath);
        }
    }
}

