/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class CertType {
    private final String certSettingPrefix;
    private final String certID;
    public static CertType HTTP = new CertType("plugins.security.ssl.http.");
    public static CertType TRANSPORT = new CertType("plugins.security.ssl.transport.");
    public static CertType TRANSPORT_CLIENT = new CertType("plugins.security.ssl.transport.client.", "transport_client");
    public static final NodeCertTypeRegistry CERT_TYPE_REGISTRY = new NodeCertTypeRegistry(HTTP, TRANSPORT, TRANSPORT_CLIENT);

    public CertType(String certSettingPrefix) {
        this.certSettingPrefix = certSettingPrefix;
        String[] parts = certSettingPrefix.split("\\.");
        this.certID = parts[parts.length - 1].toLowerCase(Locale.ROOT);
    }

    public CertType(String certSettingPrefix, String certID) {
        this.certSettingPrefix = certSettingPrefix;
        this.certID = certID;
    }

    public String sslSettingPrefix() {
        return this.certSettingPrefix;
    }

    public String id() {
        return this.certID;
    }

    public String toString() {
        return this.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertType certType = (CertType)o;
        return this.id().equals(certType.id());
    }

    public int hashCode() {
        return Objects.hash(this.id());
    }

    public static class NodeCertTypeRegistry
    implements Iterable<CertType> {
        private final Set<CertType> registeredCertType = new HashSet<CertType>();

        public NodeCertTypeRegistry(CertType ... initialCertTypes) {
            for (CertType certType : initialCertTypes) {
                this.register(certType);
            }
        }

        public void register(CertType certType) {
            this.registeredCertType.add(certType);
        }

        public boolean contains(CertType certType) {
            return this.registeredCertType.contains(certType);
        }

        public boolean contains(String certID) {
            for (CertType certType : this.registeredCertType) {
                if (!Objects.equals(certType.id(), certID)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public Iterator<CertType> iterator() {
            return Collections.unmodifiableSet(this.registeredCertType).iterator();
        }
    }

    public static enum LegacyCertType {
        HTTP,
        TRANSPORT,
        TRANSPORT_CLIENT;

    }
}

