/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.cellsystem;

import java.util.Arrays;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.Cell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.ContainerArea;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.ContainerCell;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;

public class StripContainerCell
extends ContainerCell {
    private final Strip containerMode;
    private final boolean symmetrical;
    private final double gap;
    private final Cell[] cells = new Cell[ContainerArea.values().length];

    public StripContainerCell(Strip mode, boolean symmetrical, double gap) {
        this.containerMode = mode;
        this.symmetrical = symmetrical;
        this.gap = gap;
    }

    public Strip getContainerMode() {
        return this.containerMode;
    }

    public double getGap() {
        return this.gap;
    }

    public Cell getCell(ContainerArea area) {
        return this.cells[area.ordinal()];
    }

    public void setCell(ContainerArea area, Cell cell) {
        this.cells[area.ordinal()] = cell;
    }

    @Override
    public double getMinimumWidth() {
        double width = 0.0;
        if (this.containerMode == Strip.VERTICAL) {
            width = Arrays.stream(this.cells).filter(cell -> cell != null && cell.isContributingToMinimumWidth()).mapToDouble(cell -> cell.getMinimumWidth()).max().orElse(0.0);
        } else {
            double[] cellWidths = this.minCellWidths(true);
            int activeCells = 0;
            double[] dArray = cellWidths;
            int n = cellWidths.length;
            int n2 = 0;
            while (n2 < n) {
                double cellWidth = dArray[n2];
                if (cellWidth > 0.0) {
                    width += cellWidth;
                    ++activeCells;
                }
                ++n2;
            }
            if (activeCells > 1) {
                width += this.gap * (double)(activeCells - 1);
            }
        }
        return width > 0.0 ? width + this.getPadding().left + this.getPadding().right : 0.0;
    }

    @Override
    public double getMinimumHeight() {
        double height = 0.0;
        if (this.containerMode == Strip.VERTICAL) {
            double[] cellHeights = this.minCellHeights(true);
            int activeCells = 0;
            double[] dArray = cellHeights;
            int n = cellHeights.length;
            int n2 = 0;
            while (n2 < n) {
                double cellHeight = dArray[n2];
                if (cellHeight > 0.0) {
                    height += cellHeight;
                    ++activeCells;
                }
                ++n2;
            }
            if (activeCells > 1) {
                height += this.gap * (double)(activeCells - 1);
            }
        } else {
            height = Arrays.stream(this.cells).filter(cell -> cell != null && cell.isContributingToMinimumHeight()).mapToDouble(cell -> cell.getMinimumHeight()).max().orElse(0.0);
        }
        return height > 0.0 ? height + this.getPadding().top + this.getPadding().bottom : 0.0;
    }

    @Override
    public void layoutChildrenHorizontally() {
        ElkRectangle cellRectangle = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        if (this.containerMode == Strip.VERTICAL) {
            double xPos = cellRectangle.x + cellPadding.left;
            double width = cellRectangle.width - cellPadding.left - cellPadding.right;
            Cell[] cellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell childCell = cellArray[n2];
                this.applyHorizontalLayout(childCell, xPos, width);
                ++n2;
            }
        } else {
            double[] cellWidths = this.minCellWidths(false);
            this.applyHorizontalLayout(this.cells[0], cellRectangle.x + cellPadding.left, cellWidths[0]);
            this.applyHorizontalLayout(this.cells[2], cellRectangle.x + cellRectangle.width - cellPadding.right - cellWidths[2], cellWidths[2]);
            double freeContentAreaWidth = cellRectangle.width - cellPadding.left - cellPadding.right;
            if (cellWidths[0] > 0.0) {
                freeContentAreaWidth -= cellWidths[0] + this.gap;
                cellWidths[0] = cellWidths[0] + this.gap;
            }
            if (cellWidths[2] > 0.0) {
                freeContentAreaWidth -= cellWidths[2] + this.gap;
            }
            cellWidths[1] = Math.max(cellWidths[1], freeContentAreaWidth);
            this.applyHorizontalLayout(this.cells[1], cellRectangle.x + cellPadding.left + cellWidths[0] - (cellWidths[1] - freeContentAreaWidth) / 2.0, cellWidths[1]);
        }
        Cell[] cellArray = this.cells;
        int n = this.cells.length;
        int n3 = 0;
        while (n3 < n) {
            Cell childCell = cellArray[n3];
            if (childCell instanceof ContainerCell) {
                ((ContainerCell)childCell).layoutChildrenHorizontally();
            }
            ++n3;
        }
    }

    @Override
    public void layoutChildrenVertically() {
        ElkRectangle cellRectangle = this.getCellRectangle();
        ElkPadding cellPadding = this.getPadding();
        if (this.containerMode == Strip.VERTICAL) {
            double contentAreaHeight;
            double[] cellHeights = this.minCellHeights(false);
            this.applyVerticalLayout(this.cells[0], cellRectangle.y + cellPadding.top, cellHeights[0]);
            this.applyVerticalLayout(this.cells[2], cellRectangle.y + cellRectangle.height - cellPadding.bottom - cellHeights[2], cellHeights[2]);
            double contentAreaFreeHeight = contentAreaHeight = cellRectangle.height - cellPadding.top - cellPadding.bottom;
            if (cellHeights[0] > 0.0) {
                cellHeights[0] = cellHeights[0] + this.gap;
                contentAreaFreeHeight -= cellHeights[0];
            }
            if (cellHeights[2] > 0.0) {
                contentAreaFreeHeight -= cellHeights[2] + this.gap;
            }
            cellHeights[1] = Math.max(cellHeights[1], contentAreaFreeHeight);
            this.applyVerticalLayout(this.cells[1], cellRectangle.y + cellPadding.top + cellHeights[0] - (cellHeights[1] - contentAreaFreeHeight) / 2.0, cellHeights[1]);
        } else {
            double yPos = cellRectangle.y + cellPadding.top;
            double height = cellRectangle.height - cellPadding.top - cellPadding.bottom;
            Cell[] cellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                Cell childCell = cellArray[n2];
                this.applyVerticalLayout(childCell, yPos, height);
                ++n2;
            }
        }
        Cell[] cellArray = this.cells;
        int n = this.cells.length;
        int n3 = 0;
        while (n3 < n) {
            Cell childCell = cellArray[n3];
            if (childCell instanceof ContainerCell) {
                ((ContainerCell)childCell).layoutChildrenVertically();
            }
            ++n3;
        }
    }

    private double[] minCellWidths(boolean respectContributionFlag) {
        double[] cellWidths = new double[]{StripContainerCell.minWidthOfCell(this.cells[0], respectContributionFlag), StripContainerCell.minWidthOfCell(this.cells[1], respectContributionFlag), StripContainerCell.minWidthOfCell(this.cells[2], respectContributionFlag)};
        if (this.symmetrical) {
            cellWidths[0] = Math.max(cellWidths[0], cellWidths[2]);
            cellWidths[2] = cellWidths[0];
        }
        return cellWidths;
    }

    private double[] minCellHeights(boolean respectContributionFlag) {
        double[] cellHeights = new double[]{StripContainerCell.minHeightOfCell(this.cells[0], respectContributionFlag), StripContainerCell.minHeightOfCell(this.cells[1], respectContributionFlag), StripContainerCell.minHeightOfCell(this.cells[2], respectContributionFlag)};
        if (this.symmetrical) {
            cellHeights[0] = Math.max(cellHeights[0], cellHeights[2]);
            cellHeights[2] = cellHeights[0];
        }
        return cellHeights;
    }

    public static enum Strip {
        VERTICAL,
        HORIZONTAL;

    }
}

