/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.awt.Component;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLGeneralAxiomEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLGeneralClassAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class OWLGeneralClassAxiomsFrameSection
extends AbstractOWLFrameSection<OWLOntology, OWLClassAxiom, OWLClassAxiom> {
    public OWLGeneralClassAxiomsFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLOntology> frame) {
        super(editorKit, "General class axioms", "General class axiom", frame);
    }

    @Override
    protected OWLClassAxiom createAxiom(OWLClassAxiom object) {
        return object;
    }

    @Override
    public OWLObjectEditor<OWLClassAxiom> getObjectEditor() {
        return new OWLGeneralAxiomEditor(this.getOWLEditorKit());
    }

    @Override
    public void handleEditingFinished(Set<OWLClassAxiom> editedObjects) {
        super.handleEditingFinished(editedObjects);
        OWLGeneralClassAxiomsFrameSection.checkEditedAxiom(this.getOWLEditorKit(), editedObjects);
    }

    static void checkEditedAxiom(OWLEditorKit editorKit, Set<OWLClassAxiom> editedObjects) {
        OWLClassAxiom axiom = editedObjects.iterator().next();
        OWLOntology ontology = editorKit.getOWLModelManager().getActiveOntology();
        if (ontology.containsAxiom((OWLAxiom)axiom) && !ontology.getGeneralClassAxioms().contains(axiom)) {
            JOptionPane.showMessageDialog((Component)((Object)editorKit.getOWLWorkspace()), "Edited axiom is not a general class axiom.  It has been added to\nthe ontology but will not show in the General Class Axiom Window.");
        }
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLClassAxiom ax : ontology.getGeneralClassAxioms()) {
            this.addRow(new OWLGeneralClassAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLOntology)this.getRootObject(), ax));
        }
    }

    @Override
    protected void clear() {
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLOntology, OWLClassAxiom, OWLClassAxiom>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLSubClassOfAxiom) {
            return ((OWLSubClassOfAxiom)axiom).getSubClass().isAnonymous();
        }
        if (axiom instanceof OWLDisjointClassesAxiom) {
            for (OWLClassExpression desc : ((OWLDisjointClassesAxiom)axiom).getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                return false;
            }
            return true;
        }
        if (axiom instanceof OWLEquivalentClassesAxiom) {
            for (OWLClassExpression desc : ((OWLEquivalentClassesAxiom)axiom).getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

